/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OkHttp3ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Deprecated(since="6.1", forRemoval=true)
class OkHttp3ClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final OkHttpClient client;
    private final URI uri;
    private final HttpMethod method;

    public OkHttp3ClientHttpRequest(OkHttpClient client, URI uri, HttpMethod method) {
        this.client = client;
        this.uri = uri;
        this.method = method;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        RequestBody requestBody;
        if (body2 != null) {
            requestBody = new BodyRequestBody(headers, body2);
        } else if (okhttp3.internal.http.HttpMethod.requiresRequestBody(this.getMethod().name())) {
            String header = headers.getFirst("Content-Type");
            MediaType contentType = header != null ? MediaType.parse(header) : null;
            requestBody = RequestBody.create(contentType, new byte[0]);
        } else {
            requestBody = null;
        }
        Request.Builder builder = new Request.Builder().url(this.uri.toURL());
        builder.method(this.method.name(), requestBody);
        headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                builder.addHeader((String)headerName, headerValue);
            }
        }));
        Request request = builder.build();
        return new OkHttp3ClientHttpResponse(this.client.newCall(request).execute());
    }

    private static class BodyRequestBody
    extends RequestBody {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public BodyRequestBody(HttpHeaders headers, StreamingHttpOutputMessage.Body body2) {
            this.headers = headers;
            this.body = body2;
        }

        @Override
        public long contentLength() {
            return this.headers.getContentLength();
        }

        @Override
        @Nullable
        public MediaType contentType() {
            String contentType = this.headers.getFirst("Content-Type");
            if (StringUtils.hasText(contentType)) {
                return MediaType.parse(contentType);
            }
            return null;
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            this.body.writeTo(sink2.outputStream());
        }

        @Override
        public boolean isOneShot() {
            return !this.body.repeatable();
        }
    }
}

