/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.codec.KotlinSerializationSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationBinaryEncoder<T extends BinaryFormat>
extends KotlinSerializationSupport<T>
implements Encoder<Object> {
    private final ByteArrayEncoder byteArrayEncoder = new ByteArrayEncoder();

    protected KotlinSerializationBinaryEncoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getEncodableMimeTypes(ResolvableType elementType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<?> inputStream2, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream2 instanceof Mono) {
            return Mono.from(inputStream2).map(value -> this.encodeValue(value, bufferFactory, elementType, mimeType, hints)).flux();
        }
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, elementType);
        return Flux.from(inputStream2).collectList().map(list -> this.encodeValue(list, bufferFactory, listType, mimeType, hints)).flux();
    }

    @Override
    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        KSerializer<Object> serializer = this.serializer(valueType);
        if (serializer == null) {
            throw new EncodingException("Could not find KSerializer for " + String.valueOf(valueType));
        }
        byte[] bytes = ((BinaryFormat)this.format()).encodeToByteArray(serializer, value);
        return this.byteArrayEncoder.encodeValue(bytes, bufferFactory, valueType, mimeType, (Map<String, Object>)null);
    }
}

