/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.ObjectUtils;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean2, Method method) {
        super(bean2, method);
    }

    public InvocableHandlerMethod(Object bean2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean2, methodName, parameterTypes);
    }

    public void setMessageMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.resolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    @Nullable
    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        Object[] args2 = this.getMethodArgumentValues(message, providedArgs);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Arguments: " + Arrays.toString(args2));
        }
        return this.doInvoke(args2);
    }

    protected Object[] getMethodArgumentValues(Message<?> message, Object ... providedArgs) throws Exception {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty(parameters)) {
            return EMPTY_ARGS;
        }
        Object[] args2 = new Object[parameters.length];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            Object parameter = parameters[i2];
            ((MethodParameter)parameter).initParameterNameDiscovery(this.parameterNameDiscoverer);
            args2[i2] = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, providedArgs);
            if (args2[i2] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new MethodArgumentResolutionException(message, (MethodParameter)parameter, InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, "No suitable resolver"));
            }
            try {
                args2[i2] = this.resolvers.resolveArgument((MethodParameter)parameter, message);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (this.logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(((MethodParameter)parameter).getExecutable().toGenericString())) {
                    this.logger.debug(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, exMsg));
                }
                throw ex;
            }
        }
        return args2;
    }

    @Nullable
    protected Object doInvoke(Object ... args2) throws Exception {
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args2);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.getBridgedMethod(), this.getBean(), args2);
            String text = ex.getMessage() == null || ex.getCause() instanceof NullPointerException ? "Illegal argument" : ex.getMessage();
            throw new IllegalStateException(this.formatInvokeError(text, args2), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            if (targetException instanceof Error) {
                Error error = (Error)targetException;
                throw error;
            }
            if (targetException instanceof Exception) {
                Exception exception = (Exception)targetException;
                throw exception;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", args2), targetException);
        }
    }

    MethodParameter getAsyncReturnValueType(@Nullable Object returnValue) {
        return new AsyncResultMethodParameter(returnValue);
    }

    private class AsyncResultMethodParameter
    extends AnnotatedMethod.AnnotatedMethodParameter {
        @Nullable
        private final Object returnValue;
        private final ResolvableType returnType;

        public AsyncResultMethodParameter(Object returnValue) {
            super((AnnotatedMethod)InvocableHandlerMethod.this, -1);
            this.returnValue = returnValue;
            this.returnType = ResolvableType.forType(super.getGenericParameterType()).getGeneric(new int[0]);
        }

        protected AsyncResultMethodParameter(AsyncResultMethodParameter original) {
            super((AnnotatedMethod)InvocableHandlerMethod.this, original);
            this.returnValue = original.returnValue;
            this.returnType = original.returnType;
        }

        @Override
        public Class<?> getParameterType() {
            if (this.returnValue != null) {
                return this.returnValue.getClass();
            }
            if (!ResolvableType.NONE.equals(this.returnType)) {
                return this.returnType.toClass();
            }
            return super.getParameterType();
        }

        @Override
        public Type getGenericParameterType() {
            return this.returnType.getType();
        }

        @Override
        public AsyncResultMethodParameter clone() {
            return new AsyncResultMethodParameter(this);
        }
    }
}

