/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.aop.support.annotation.AnnotationMethodMatcher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryListener;
import org.springframework.retry.annotation.AnnotationAwareRetryOperationsInterceptor;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Role(value=2)
@Component
public class RetryConfiguration
extends AbstractPointcutAdvisor
implements IntroductionAdvisor,
BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton,
ImportAware {
    @Nullable
    protected AnnotationAttributes enableRetry;
    private AnnotationAwareRetryOperationsInterceptor advice;
    private Pointcut pointcut;
    private RetryContextCache retryContextCache;
    private List<RetryListener> retryListeners;
    private MethodArgumentsKeyGenerator methodArgumentsKeyGenerator;
    private NewMethodArgumentsIdentifier newMethodArgumentsIdentifier;
    private Sleeper sleeper;
    private BeanFactory beanFactory;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableRetry = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableRetry.class.getName()));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.retryContextCache = this.findBean(RetryContextCache.class);
        this.methodArgumentsKeyGenerator = this.findBean(MethodArgumentsKeyGenerator.class);
        this.newMethodArgumentsIdentifier = this.findBean(NewMethodArgumentsIdentifier.class);
        this.sleeper = this.findBean(Sleeper.class);
        LinkedHashSet<Class<? extends Annotation>> retryableAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(1);
        retryableAnnotationTypes.add(Retryable.class);
        this.pointcut = this.buildPointcut(retryableAnnotationTypes);
        this.advice = this.buildAdvice();
        this.advice.setBeanFactory(this.beanFactory);
        if (this.enableRetry != null) {
            this.setOrder((Integer)this.enableRetry.getNumber("order"));
        }
    }

    @Override
    public void afterSingletonsInstantiated() {
        this.retryListeners = this.findBeans(RetryListener.class);
        if (this.retryListeners != null) {
            this.advice.setListeners(this.retryListeners);
        }
    }

    private <T> List<T> findBeans(Class<? extends T> type) {
        ListableBeanFactory listable;
        if (this.beanFactory instanceof ListableBeanFactory && (listable = (ListableBeanFactory)this.beanFactory).getBeanNamesForType(type).length > 0) {
            ArrayList<? extends T> list = new ArrayList<T>(listable.getBeansOfType(type, false, false).values());
            OrderComparator.sort(list);
            return list;
        }
        return null;
    }

    private <T> T findBean(Class<? extends T> type) {
        ListableBeanFactory listable;
        if (this.beanFactory instanceof ListableBeanFactory && (listable = (ListableBeanFactory)this.beanFactory).getBeanNamesForType(type, false, false).length == 1) {
            return listable.getBean(type);
        }
        return null;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public ClassFilter getClassFilter() {
        return this.pointcut.getClassFilter();
    }

    @Override
    public Class<?>[] getInterfaces() {
        return new Class[]{org.springframework.retry.interceptor.Retryable.class};
    }

    @Override
    public void validateInterfaces() throws IllegalArgumentException {
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    protected AnnotationAwareRetryOperationsInterceptor buildAdvice() {
        AnnotationAwareRetryOperationsInterceptor interceptor = new AnnotationAwareRetryOperationsInterceptor();
        if (this.retryContextCache != null) {
            interceptor.setRetryContextCache(this.retryContextCache);
        }
        if (this.methodArgumentsKeyGenerator != null) {
            interceptor.setKeyGenerator(this.methodArgumentsKeyGenerator);
        }
        if (this.newMethodArgumentsIdentifier != null) {
            interceptor.setNewItemIdentifier(this.newMethodArgumentsIdentifier);
        }
        if (this.sleeper != null) {
            interceptor.setSleeper(this.sleeper);
        }
        return interceptor;
    }

    protected Pointcut buildPointcut(Set<Class<? extends Annotation>> retryAnnotationTypes) {
        ComposablePointcut result = null;
        for (Class<? extends Annotation> retryAnnotationType : retryAnnotationTypes) {
            AnnotationClassOrMethodPointcut filter2 = new AnnotationClassOrMethodPointcut(retryAnnotationType);
            if (result == null) {
                result = new ComposablePointcut(filter2);
                continue;
            }
            result.union(filter2);
        }
        return result;
    }

    private final class AnnotationClassOrMethodPointcut
    extends StaticMethodMatcherPointcut {
        private final MethodMatcher methodResolver;

        AnnotationClassOrMethodPointcut(Class<? extends Annotation> annotationType) {
            this.methodResolver = new AnnotationMethodMatcher(annotationType);
            this.setClassFilter(new AnnotationClassOrMethodFilter(annotationType));
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return this.getClassFilter().matches(targetClass) || this.methodResolver.matches(method, targetClass);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationClassOrMethodPointcut)) {
                return false;
            }
            AnnotationClassOrMethodPointcut otherAdvisor = (AnnotationClassOrMethodPointcut)other;
            return ObjectUtils.nullSafeEquals(this.methodResolver, otherAdvisor.methodResolver);
        }

        public int hashCode() {
            return Objects.hash(this.methodResolver);
        }
    }

    private static class AnnotationMethodsResolver {
        private final Class<? extends Annotation> annotationType;

        public AnnotationMethodsResolver(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean hasAnnotatedMethods(Class<?> clazz) {
            AtomicBoolean found = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(clazz, method -> {
                if (found.get()) {
                    return;
                }
                Annotation annotation = AnnotationUtils.findAnnotation(method, this.annotationType);
                if (annotation != null) {
                    found.set(true);
                }
            });
            return found.get();
        }
    }

    private final class AnnotationClassOrMethodFilter
    extends AnnotationClassFilter {
        private final AnnotationMethodsResolver methodResolver;

        AnnotationClassOrMethodFilter(Class<? extends Annotation> annotationType) {
            super(annotationType, true);
            this.methodResolver = new AnnotationMethodsResolver(annotationType);
        }

        @Override
        public boolean matches(Class<?> clazz) {
            return super.matches(clazz) || this.methodResolver.hasAnnotatedMethods(clazz);
        }
    }
}

