/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.backoff;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.retry.RetryContext;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.ThreadWaitSleeper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ExponentialBackOffPolicy
implements SleepingBackOffPolicy<ExponentialBackOffPolicy> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final long DEFAULT_INITIAL_INTERVAL = 100L;
    public static final long DEFAULT_MAX_INTERVAL = 30000L;
    public static final double DEFAULT_MULTIPLIER = 2.0;
    private long initialInterval = 100L;
    private long maxInterval = 30000L;
    private double multiplier = 2.0;
    private Supplier<Long> initialIntervalSupplier;
    private Supplier<Long> maxIntervalSupplier;
    private Supplier<Double> multiplierSupplier;
    private Sleeper sleeper = new ThreadWaitSleeper();

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    @Override
    public ExponentialBackOffPolicy withSleeper(Sleeper sleeper) {
        ExponentialBackOffPolicy res = this.newInstance();
        this.cloneValues(res);
        res.setSleeper(sleeper);
        return res;
    }

    protected ExponentialBackOffPolicy newInstance() {
        return new ExponentialBackOffPolicy();
    }

    protected void cloneValues(ExponentialBackOffPolicy target) {
        target.setInitialInterval(this.getInitialInterval());
        target.setMaxInterval(this.getMaxInterval());
        target.setMultiplier(this.getMultiplier());
        target.setSleeper(this.sleeper);
    }

    public void setInitialInterval(long initialInterval) {
        if (initialInterval < 1L) {
            this.logger.warn("Initial interval must be at least 1, but was " + initialInterval);
        }
        this.initialInterval = initialInterval > 1L ? initialInterval : 1L;
    }

    public void setMultiplier(double multiplier) {
        if (multiplier <= 1.0) {
            this.logger.warn("Multiplier must be > 1.0 for effective exponential backoff, but was " + multiplier);
        }
        this.multiplier = multiplier > 1.0 ? multiplier : 1.0;
    }

    public void setMaxInterval(long maxInterval) {
        if (maxInterval < 1L) {
            this.logger.warn("Max interval must be positive, but was " + maxInterval);
        }
        this.maxInterval = maxInterval > 0L ? maxInterval : 1L;
    }

    public void initialIntervalSupplier(Supplier<Long> initialIntervalSupplier) {
        Assert.notNull(initialIntervalSupplier, "'initialIntervalSupplier' cannot be null");
        this.initialIntervalSupplier = initialIntervalSupplier;
    }

    public void multiplierSupplier(Supplier<Double> multiplierSupplier) {
        Assert.notNull(multiplierSupplier, "'multiplierSupplier' cannot be null");
        this.multiplierSupplier = multiplierSupplier;
    }

    public void maxIntervalSupplier(Supplier<Long> maxIntervalSupplier) {
        Assert.notNull(maxIntervalSupplier, "'maxIntervalSupplier' cannot be null");
        this.maxIntervalSupplier = maxIntervalSupplier;
    }

    protected Supplier<Long> getInitialIntervalSupplier() {
        return this.initialIntervalSupplier;
    }

    protected Supplier<Long> getMaxIntervalSupplier() {
        return this.maxIntervalSupplier;
    }

    protected Supplier<Double> getMultiplierSupplier() {
        return this.multiplierSupplier;
    }

    public long getInitialInterval() {
        return this.initialIntervalSupplier != null ? this.initialIntervalSupplier.get() : this.initialInterval;
    }

    public long getMaxInterval() {
        return this.maxIntervalSupplier != null ? this.maxIntervalSupplier.get() : this.maxInterval;
    }

    public double getMultiplier() {
        return this.multiplierSupplier != null ? this.multiplierSupplier.get() : this.multiplier;
    }

    @Override
    public BackOffContext start(RetryContext context) {
        return new ExponentialBackOffContext(this.initialInterval, this.multiplier, this.maxInterval, this.initialIntervalSupplier, this.multiplierSupplier, this.maxIntervalSupplier);
    }

    @Override
    public void backOff(BackOffContext backOffContext) throws BackOffInterruptedException {
        ExponentialBackOffContext context = (ExponentialBackOffContext)backOffContext;
        try {
            long sleepTime = context.getSleepAndIncrement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sleeping for " + sleepTime);
            }
            this.sleeper.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BackOffInterruptedException("Thread interrupted while sleeping", e);
        }
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + "[initialInterval=" + this.getInitialInterval() + ", multiplier=" + this.getMultiplier() + ", maxInterval=" + this.getMaxInterval() + "]";
    }

    static class ExponentialBackOffContext
    implements BackOffContext {
        private final double multiplier;
        private long interval;
        private final long maxInterval;
        private Supplier<Long> initialIntervalSupplier;
        private Supplier<Double> multiplierSupplier;
        private Supplier<Long> maxIntervalSupplier;

        public ExponentialBackOffContext(long interval, double multiplier, long maxInterval, Supplier<Long> intervalSupplier, Supplier<Double> multiplierSupplier, Supplier<Long> maxIntervalSupplier) {
            this.interval = interval;
            this.multiplier = multiplier;
            this.maxInterval = maxInterval;
            this.initialIntervalSupplier = intervalSupplier;
            this.multiplierSupplier = multiplierSupplier;
            this.maxIntervalSupplier = maxIntervalSupplier;
        }

        public synchronized long getSleepAndIncrement() {
            long max;
            long sleep = this.getInterval();
            if (sleep > (max = this.getMaxInterval())) {
                sleep = max;
            } else {
                this.interval = this.getNextInterval();
            }
            return sleep;
        }

        protected long getNextInterval() {
            return (long)((double)this.interval * this.getMultiplier());
        }

        public double getMultiplier() {
            return this.multiplierSupplier != null ? this.multiplierSupplier.get() : this.multiplier;
        }

        public long getInterval() {
            if (this.initialIntervalSupplier != null) {
                this.interval = this.initialIntervalSupplier.get();
                this.initialIntervalSupplier = null;
            }
            return this.interval;
        }

        public long getMaxInterval() {
            return this.maxIntervalSupplier != null ? this.maxIntervalSupplier.get() : this.maxInterval;
        }
    }
}

