/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.support;

import io.micrometer.core.instrument.AbstractTimerBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.util.Assert;

public class MetricsRetryListener
implements RetryListener {
    public static final String TIMER_NAME = "spring.retry";
    private final MeterRegistry meterRegistry;
    private final Map<RetryContext, Timer.Sample> retryContextToSample = Collections.synchronizedMap(new IdentityHashMap());
    private Tags customTags = Tags.empty();
    private Function<RetryContext, Iterable<Tag>> customTagsProvider = retryContext -> Tags.empty();

    public MetricsRetryListener(MeterRegistry meterRegistry) {
        Assert.notNull((Object)meterRegistry, "'meterRegistry' must not be null");
        this.meterRegistry = meterRegistry;
    }

    public void setCustomTags(@Nullable Iterable<Tag> customTags) {
        this.customTags = this.customTags.and(customTags);
    }

    public void setCustomTagsProvider(Function<RetryContext, Iterable<Tag>> customTagsProvider) {
        Assert.notNull(customTagsProvider, "'customTagsProvider' must not be null");
        this.customTagsProvider = customTagsProvider;
    }

    @Override
    public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
        this.retryContextToSample.put(context, Timer.start(this.meterRegistry));
        return true;
    }

    @Override
    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, @Nullable Throwable throwable) {
        Timer.Sample sample = this.retryContextToSample.remove(context);
        Assert.state(sample != null, () -> String.format("No 'Timer.Sample' registered for '%s'. Was the 'open()' called?", context));
        String label = Objects.requireNonNullElse(callback.getLabel(), callback.getClass().getName());
        Tags retryTags = Tags.of("name", label).and("retry.count", "" + context.getRetryCount()).and(this.customTags).and(this.customTagsProvider.apply(context)).and("exception", throwable != null ? throwable.getClass().getSimpleName() : "none");
        AbstractTimerBuilder timeBuilder = Timer.builder(TIMER_NAME).description("Metrics for Spring RetryTemplate").tags((Iterable)retryTags);
        sample.stop(((Timer.Builder)timeBuilder).register(this.meterRegistry));
    }
}

