/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.transaction.jta.ManagedTransactionAdapter;
import org.springframework.transaction.jta.TransactionFactory;
import org.springframework.util.Assert;

public class SimpleTransactionFactory
implements TransactionFactory {
    private final TransactionManager transactionManager;

    public SimpleTransactionFactory(TransactionManager transactionManager) {
        Assert.notNull((Object)transactionManager, "TransactionManager must not be null");
        this.transactionManager = transactionManager;
    }

    @Override
    public Transaction createTransaction(@Nullable String name, int timeout2) throws NotSupportedException, SystemException {
        if (timeout2 >= 0) {
            this.transactionManager.setTransactionTimeout(timeout2);
        }
        this.transactionManager.begin();
        return new ManagedTransactionAdapter(this.transactionManager);
    }

    @Override
    public boolean supportsResourceAdapterManagedTransactions() {
        return false;
    }
}

