/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.standard;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.WebSocketContainer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FutureUtils;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.standard.StandardWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.standard.StandardWebSocketSession;
import org.springframework.web.socket.adapter.standard.WebSocketToStandardExtensionAdapter;
import org.springframework.web.socket.client.AbstractWebSocketClient;

public class StandardWebSocketClient
extends AbstractWebSocketClient {
    private final WebSocketContainer webSocketContainer;
    private final Map<String, Object> userProperties = new HashMap<String, Object>();
    @Nullable
    private SSLContext sslContext;
    @Nullable
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();

    public StandardWebSocketClient() {
        this.webSocketContainer = ContainerProvider.getWebSocketContainer();
    }

    public StandardWebSocketClient(WebSocketContainer webSocketContainer) {
        Assert.notNull((Object)webSocketContainer, "WebSocketContainer must not be null");
        this.webSocketContainer = webSocketContainer;
    }

    public void setUserProperties(@Nullable Map<String, Object> userProperties) {
        if (userProperties != null) {
            this.userProperties.putAll(userProperties);
        }
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setSslContext(@Nullable SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Nullable
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setTaskExecutor(@Nullable AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Nullable
    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    protected CompletableFuture<WebSocketSession> executeInternal(WebSocketHandler webSocketHandler, HttpHeaders headers, URI uri, List<String> protocols, List<WebSocketExtension> extensions, Map<String, Object> attributes) {
        int port = StandardWebSocketClient.getPort(uri);
        InetSocketAddress localAddress = new InetSocketAddress(StandardWebSocketClient.getLocalHost(), port);
        InetSocketAddress remoteAddress = new InetSocketAddress(uri.getHost(), port);
        StandardWebSocketSession session = new StandardWebSocketSession(headers, attributes, localAddress, remoteAddress);
        ClientEndpointConfig endpointConfig = ClientEndpointConfig.Builder.create().configurator(new StandardWebSocketClientConfigurator(headers)).preferredSubprotocols(protocols).extensions(StandardWebSocketClient.adaptExtensions(extensions)).sslContext(this.getSslContext()).build();
        endpointConfig.getUserProperties().putAll(this.getUserProperties());
        StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(webSocketHandler, session);
        Callable<WebSocketSession> connectTask = () -> {
            this.webSocketContainer.connectToServer(endpoint, endpointConfig, uri);
            return session;
        };
        if (this.taskExecutor != null) {
            return FutureUtils.callAsync(connectTask, this.taskExecutor);
        }
        return FutureUtils.callAsync(connectTask);
    }

    private static List<Extension> adaptExtensions(List<WebSocketExtension> extensions) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (WebSocketExtension extension : extensions) {
            result.add(new WebSocketToStandardExtensionAdapter(extension));
        }
        return result;
    }

    private static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            return InetAddress.getLoopbackAddress();
        }
    }

    private static int getPort(URI uri) {
        if (uri.getPort() == -1) {
            String scheme = uri.getScheme().toLowerCase(Locale.ROOT);
            return "wss".equals(scheme) ? 443 : 80;
        }
        return uri.getPort();
    }

    private class StandardWebSocketClientConfigurator
    extends ClientEndpointConfig.Configurator {
        private final HttpHeaders headers;

        public StandardWebSocketClientConfigurator(HttpHeaders headers) {
            this.headers = headers;
        }

        @Override
        public void beforeRequest(Map<String, List<String>> requestHeaders) {
            requestHeaders.putAll(this.headers);
            if (StandardWebSocketClient.this.logger.isTraceEnabled()) {
                StandardWebSocketClient.this.logger.trace("Handshake request headers: " + String.valueOf(requestHeaders));
            }
        }

        @Override
        public void afterResponse(HandshakeResponse response) {
            if (StandardWebSocketClient.this.logger.isTraceEnabled()) {
                StandardWebSocketClient.this.logger.trace("Handshake response headers: " + String.valueOf(response.getHeaders()));
            }
        }
    }
}

