/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.servlet.ServletContext;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class ServerEndpointExporter
extends WebApplicationObjectSupport
implements InitializingBean,
SmartInitializingSingleton {
    @Nullable
    private List<Class<?>> annotatedEndpointClasses;
    @Nullable
    private ServerContainer serverContainer;

    public void setAnnotatedEndpointClasses(Class<?> ... annotatedEndpointClasses) {
        this.annotatedEndpointClasses = Arrays.asList(annotatedEndpointClasses);
    }

    public void setServerContainer(@Nullable ServerContainer serverContainer) {
        this.serverContainer = serverContainer;
    }

    @Nullable
    protected ServerContainer getServerContainer() {
        return this.serverContainer;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) {
        if (this.serverContainer == null) {
            this.serverContainer = (ServerContainer)servletContext.getAttribute("jakarta.websocket.server.ServerContainer");
        }
    }

    @Override
    protected boolean isContextRequired() {
        return false;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.getServerContainer() != null, "jakarta.websocket.server.ServerContainer not available");
    }

    @Override
    public void afterSingletonsInstantiated() {
        this.registerEndpoints();
    }

    protected void registerEndpoints() {
        ApplicationContext context;
        LinkedHashSet endpointClasses = new LinkedHashSet();
        if (this.annotatedEndpointClasses != null) {
            endpointClasses.addAll(this.annotatedEndpointClasses);
        }
        if ((context = this.getApplicationContext()) != null) {
            String[] endpointBeanNames;
            for (String beanName : endpointBeanNames = context.getBeanNamesForAnnotation(ServerEndpoint.class)) {
                endpointClasses.add(context.getType(beanName));
            }
        }
        for (Class clazz : endpointClasses) {
            this.registerEndpoint(clazz);
        }
        if (context != null) {
            Map<String, ServerEndpointConfig> endpointConfigMap = context.getBeansOfType(ServerEndpointConfig.class);
            for (ServerEndpointConfig endpointConfig : endpointConfigMap.values()) {
                this.registerEndpoint(endpointConfig);
            }
        }
    }

    private void registerEndpoint(Class<?> endpointClass) {
        ServerContainer serverContainer = this.getServerContainer();
        Assert.state(serverContainer != null, "No ServerContainer set. Most likely the server's own WebSocket ServletContainerInitializer has not run yet. Was the Spring ApplicationContext refreshed through a org.springframework.web.context.ContextLoaderListener, i.e. after the ServletContext has been fully initialized?");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registering @ServerEndpoint class: " + String.valueOf(endpointClass));
            }
            serverContainer.addEndpoint(endpointClass);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register @ServerEndpoint class: " + String.valueOf(endpointClass), ex);
        }
    }

    private void registerEndpoint(ServerEndpointConfig endpointConfig) {
        ServerContainer serverContainer = this.getServerContainer();
        Assert.state(serverContainer != null, "No ServerContainer set");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registering ServerEndpointConfig: " + String.valueOf(endpointConfig));
            }
            serverContainer.addEndpoint(endpointConfig);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register ServerEndpointConfig: " + String.valueOf(endpointConfig), ex);
        }
    }
}

