/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.string;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CompositeCharSequence
implements CharSequence,
Serializable {
    private static final long serialVersionUID = 4975968165050531721L;
    private final List<CharSequence> sequences;
    private transient int hashCode = 0;

    public CompositeCharSequence(CharSequence ... sequences) {
        this(Arrays.asList(sequences));
    }

    public CompositeCharSequence(List<CharSequence> sequences) {
        this.sequences = sequences;
    }

    @Override
    public int length() {
        int length = 0;
        for (CharSequence sequence2 : this.sequences) {
            length += sequence2.length();
        }
        return length;
    }

    @Override
    public char charAt(int index) {
        int relativeIndex = index;
        for (CharSequence sequence2 : this.sequences) {
            if (relativeIndex < sequence2.length()) {
                return sequence2.charAt(relativeIndex);
            }
            relativeIndex -= sequence2.length();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        LinkedList<CharSequence> result = null;
        int relativeStart = start;
        int relativeEnd = end;
        for (CharSequence sequence2 : this.sequences) {
            if (relativeStart < sequence2.length() && relativeEnd > 0) {
                CharSequence subSequence = sequence2.subSequence(Math.max(relativeStart, 0), Math.min(relativeEnd, sequence2.length()));
                if (result == null) {
                    if (relativeStart >= 0 && relativeEnd <= sequence2.length()) {
                        return subSequence;
                    }
                    result = new LinkedList<CharSequence>();
                }
                result.add(subSequence);
            }
            relativeStart -= sequence2.length();
            relativeEnd -= sequence2.length();
        }
        return new CompositeCharSequence(result);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            for (int i2 = 0; i2 < this.length(); ++i2) {
                result = 31 * result + this.charAt(i2);
            }
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharSequence)) {
            return false;
        }
        CharSequence sequence2 = (CharSequence)object;
        int length = sequence2.length();
        if (this.length() != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.charAt(i2) == sequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        CharBuffer buffer = CharBuffer.allocate(this.length());
        for (CharSequence sequence2 : this.sequences) {
            buffer.put(CharBuffer.wrap(sequence2));
        }
        return String.valueOf(buffer.array());
    }
}

