/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.bip32.nut;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip32.Bip32;
import xyz.tcheeric.bips.util.HexUtils;

public class Nut13Derivation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Nut13Derivation.class);
    public static final int NUT13_PURPOSE = 129372;
    public static final int COIN_TYPE = 0;
    public static final int INDEX_SECRET = 0;
    public static final int INDEX_BLINDING_FACTOR = 1;
    private static final long KEYSET_ID_MODULUS = Integer.MAX_VALUE;

    public static int keysetIdToInt(String keysetIdHex) {
        if (keysetIdHex == null || keysetIdHex.isEmpty()) {
            LOGGER.warn("Nut13Derivation keyset_id_to_int_failed reason=blank_input impact=derivation_aborted");
            throw new IllegalArgumentException("Keyset ID cannot be null or empty");
        }
        String normalizedHex = keysetIdHex.trim();
        if (normalizedHex.toLowerCase().startsWith("0x")) {
            normalizedHex = normalizedHex.substring(2);
        }
        BigInteger keysetId = new BigInteger(normalizedHex, 16);
        BigInteger modulus = BigInteger.valueOf(Integer.MAX_VALUE);
        BigInteger reduced = keysetId.mod(modulus);
        LOGGER.debug("Nut13Derivation keyset_id_to_int_succeeded normalized_length={} keyset_id_int={} impact=derivation_continues", (Object)normalizedHex.length(), (Object)reduced.intValue());
        return reduced.intValue();
    }

    public static int keysetIdToInt(byte[] keysetIdBytes) {
        if (keysetIdBytes == null || keysetIdBytes.length == 0) {
            LOGGER.warn("Nut13Derivation keyset_id_to_int_failed reason=empty_bytes impact=derivation_aborted");
            throw new IllegalArgumentException("Keyset ID bytes cannot be null or empty");
        }
        BigInteger keysetId = new BigInteger(1, keysetIdBytes);
        BigInteger modulus = BigInteger.valueOf(Integer.MAX_VALUE);
        BigInteger reduced = keysetId.mod(modulus);
        LOGGER.debug("Nut13Derivation keyset_id_to_int_succeeded byte_length={} keyset_id_int={} impact=derivation_continues", (Object)keysetIdBytes.length, (Object)reduced.intValue());
        return reduced.intValue();
    }

    public static String buildSecretDerivationPath(int keysetIdInt, int counter) {
        return Nut13Derivation.buildDerivationPath(keysetIdInt, counter, 0);
    }

    public static String buildBlindingFactorDerivationPath(int keysetIdInt, int counter) {
        return Nut13Derivation.buildDerivationPath(keysetIdInt, counter, 1);
    }

    private static String buildDerivationPath(int keysetIdInt, int counter, int finalIndex) {
        return String.format("m/%d'/%d'/%d'/%d'/%d", 129372, 0, keysetIdInt, counter, finalIndex);
    }

    public static byte[] deriveSecret(DeterministicKey masterKey, String keysetIdHex, int counter) {
        int keysetIdInt = Nut13Derivation.keysetIdToInt(keysetIdHex);
        String path = Nut13Derivation.buildSecretDerivationPath(keysetIdInt, counter);
        DeterministicKey derivedKey = Bip32.deriveKey(masterKey, path);
        LOGGER.debug("Nut13Derivation derive_secret_succeeded keyset_id_int={} counter={} impact=secret_ready", (Object)keysetIdInt, (Object)counter);
        return Bip32.getPrivateKeyBytes(derivedKey);
    }

    public static byte[] deriveBlindingFactor(DeterministicKey masterKey, String keysetIdHex, int counter) {
        int keysetIdInt = Nut13Derivation.keysetIdToInt(keysetIdHex);
        String path = Nut13Derivation.buildBlindingFactorDerivationPath(keysetIdInt, counter);
        DeterministicKey derivedKey = Bip32.deriveKey(masterKey, path);
        LOGGER.debug("Nut13Derivation derive_blinding_factor_succeeded keyset_id_int={} counter={} impact=blinding_factor_ready", (Object)keysetIdInt, (Object)counter);
        return Bip32.getPrivateKeyBytes(derivedKey);
    }

    public static DeterministicKey deriveSecretKey(DeterministicKey masterKey, int keysetIdInt, int counter) {
        return Nut13Derivation.deriveKey(masterKey, keysetIdInt, counter, 0);
    }

    public static DeterministicKey deriveBlindingFactorKey(DeterministicKey masterKey, int keysetIdInt, int counter) {
        return Nut13Derivation.deriveKey(masterKey, keysetIdInt, counter, 1);
    }

    private static DeterministicKey deriveKey(DeterministicKey masterKey, int keysetIdInt, int counter, int finalIndex) {
        ChildNumber[] path = new ChildNumber[]{new ChildNumber(129372, true), new ChildNumber(0, true), new ChildNumber(keysetIdInt, true), new ChildNumber(counter, true), new ChildNumber(finalIndex, false)};
        return Bip32.deriveKey(masterKey, path);
    }

    public static byte[] deriveSecretFromMnemonic(String mnemonicPhrase, String passphrase, String keysetIdHex, int counter) {
        return Nut13Derivation.deriveSecretFromMnemonic(Nut13DerivationParams.builder().mnemonicPhrase(mnemonicPhrase).passphrase(passphrase).keysetIdHex(keysetIdHex).counter(counter).build());
    }

    public static byte[] deriveBlindingFactorFromMnemonic(String mnemonicPhrase, String passphrase, String keysetIdHex, int counter) {
        return Nut13Derivation.deriveBlindingFactorFromMnemonic(Nut13DerivationParams.builder().mnemonicPhrase(mnemonicPhrase).passphrase(passphrase).keysetIdHex(keysetIdHex).counter(counter).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deriveSecretFromMnemonic(Nut13DerivationParams params) {
        Objects.requireNonNull(params, "params cannot be null");
        byte[] seed = Bip32.mnemonicToSeed(params.getMnemonicPhrase(), params.getPassphrase());
        DeterministicKey masterKey = Bip32.deriveMasterKey(seed);
        try {
            LOGGER.debug("Nut13Derivation derive_secret_from_mnemonic_started counter={} impact=seed_material_loaded", (Object)params.getCounter());
            byte[] byArray = Nut13Derivation.deriveSecret(masterKey, params.getKeysetIdHex(), params.getCounter());
            return byArray;
        }
        finally {
            Arrays.fill(seed, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deriveBlindingFactorFromMnemonic(Nut13DerivationParams params) {
        Objects.requireNonNull(params, "params cannot be null");
        byte[] seed = Bip32.mnemonicToSeed(params.getMnemonicPhrase(), params.getPassphrase());
        DeterministicKey masterKey = Bip32.deriveMasterKey(seed);
        try {
            LOGGER.debug("Nut13Derivation derive_blinding_factor_from_mnemonic_started counter={} impact=seed_material_loaded", (Object)params.getCounter());
            byte[] byArray = Nut13Derivation.deriveBlindingFactor(masterKey, params.getKeysetIdHex(), params.getCounter());
            return byArray;
        }
        finally {
            Arrays.fill(seed, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretAndBlindingFactor deriveSecretAndBlindingFactor(Nut13DerivationParams params) {
        Objects.requireNonNull(params, "params cannot be null");
        byte[] seed = Bip32.mnemonicToSeed(params.getMnemonicPhrase(), params.getPassphrase());
        DeterministicKey masterKey = Bip32.deriveMasterKey(seed);
        try {
            SecretAndBlindingFactor secretAndBlindingFactor = Nut13Derivation.deriveSecretAndBlindingFactor(masterKey, params.getKeysetIdHex(), params.getCounter());
            LOGGER.debug("Nut13Derivation derive_secret_and_blinding_from_mnemonic_succeeded counter={} impact=secrets_ready", (Object)params.getCounter());
            SecretAndBlindingFactor secretAndBlindingFactor2 = secretAndBlindingFactor;
            return secretAndBlindingFactor2;
        }
        finally {
            Arrays.fill(seed, (byte)0);
        }
    }

    public static SecretAndBlindingFactor deriveSecretAndBlindingFactor(DeterministicKey masterKey, String keysetIdHex, int counter) {
        byte[] secret = Nut13Derivation.deriveSecret(masterKey, keysetIdHex, counter);
        byte[] blindingFactor = Nut13Derivation.deriveBlindingFactor(masterKey, keysetIdHex, counter);
        SecretAndBlindingFactor secretAndBlindingFactor = new SecretAndBlindingFactor(secret, blindingFactor);
        Arrays.fill(secret, (byte)0);
        Arrays.fill(blindingFactor, (byte)0);
        LOGGER.debug("Nut13Derivation derive_secret_and_blinding_succeeded keyset_id_hex_length={} counter={} impact=secrets_ready", (Object)keysetIdHex.length(), (Object)counter);
        return secretAndBlindingFactor;
    }

    public record Nut13DerivationParams(String mnemonicPhrase, String passphrase, String keysetIdHex, int counter) {
        public Nut13DerivationParams {
            Objects.requireNonNull(mnemonicPhrase, "mnemonicPhrase cannot be null");
            Objects.requireNonNull(keysetIdHex, "keysetIdHex cannot be null");
            passphrase = passphrase == null ? "" : passphrase;
        }

        public Nut13DerivationParams(String mnemonicPhrase, String keysetIdHex, int counter) {
            this(mnemonicPhrase, "", keysetIdHex, counter);
        }

        public String getMnemonicPhrase() {
            return this.mnemonicPhrase;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getKeysetIdHex() {
            return this.keysetIdHex;
        }

        public int getCounter() {
            return this.counter;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String mnemonicPhrase;
            private String passphrase = "";
            private String keysetIdHex;
            private Integer counter;

            private Builder() {
            }

            public Builder mnemonicPhrase(String mnemonicPhrase) {
                this.mnemonicPhrase = mnemonicPhrase;
                return this;
            }

            public Builder passphrase(String passphrase) {
                this.passphrase = passphrase;
                return this;
            }

            public Builder keysetIdHex(String keysetIdHex) {
                this.keysetIdHex = keysetIdHex;
                return this;
            }

            public Builder counter(int counter) {
                this.counter = counter;
                return this;
            }

            public Nut13DerivationParams build() {
                if (this.counter == null) {
                    throw new IllegalStateException("counter must be provided");
                }
                return new Nut13DerivationParams(this.mnemonicPhrase, this.passphrase, this.keysetIdHex, this.counter);
            }
        }
    }

    public record SecretAndBlindingFactor(byte[] secret, byte[] blindingFactor) {
        private final byte[] secret;
        private final byte[] blindingFactor;

        public SecretAndBlindingFactor {
            secret = Arrays.copyOf(Objects.requireNonNull(secret, "secret cannot be null"), secret.length);
            blindingFactor = Arrays.copyOf(Objects.requireNonNull(blindingFactor, "blindingFactor cannot be null"), blindingFactor.length);
        }

        public byte[] secret() {
            return Arrays.copyOf(this.secret, this.secret.length);
        }

        public byte[] blindingFactor() {
            return Arrays.copyOf(this.blindingFactor, this.blindingFactor.length);
        }

        public byte[] getSecret() {
            return this.secret();
        }

        public byte[] getBlindingFactor() {
            return this.blindingFactor();
        }

        public String getSecretHex() {
            return HexUtils.toHex(this.secret);
        }

        public String getBlindingFactorHex() {
            return HexUtils.toHex(this.blindingFactor);
        }
    }
}

