/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.bip39;

import java.security.SecureRandom;
import java.util.List;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import xyz.tcheeric.bips.bip39.MnemonicGenerator;
import xyz.tcheeric.bips.bip39.MnemonicValidator;
import xyz.tcheeric.bips.bip39.SeedCalculator;
import xyz.tcheeric.bips.bip39.WordList;

public class Bip39 {
    private static final WordList DEFAULT_WORDLIST = WordList.english();

    public static String generateMnemonic(int wordCount) {
        return Bip39.generateMnemonic(wordCount, DEFAULT_WORDLIST);
    }

    public static String generateMnemonic(int wordCount, WordList wordList) {
        MnemonicGenerator generator = new MnemonicGenerator(wordList);
        return generator.generateRandom(wordCount);
    }

    public static String generateMnemonic(int wordCount, WordList wordList, SecureRandom random) {
        MnemonicGenerator generator = new MnemonicGenerator(wordList);
        return generator.generateRandom(wordCount, random);
    }

    public static String generateMnemonic(byte[] entropy) {
        return Bip39.generateMnemonic(entropy, DEFAULT_WORDLIST);
    }

    public static String generateMnemonic(byte[] entropy, WordList wordList) {
        MnemonicGenerator generator = new MnemonicGenerator(wordList);
        return generator.generate(entropy);
    }

    public static boolean isValidMnemonic(String mnemonic) {
        return Bip39.isValidMnemonic(mnemonic, DEFAULT_WORDLIST);
    }

    public static boolean isValidMnemonic(String mnemonic, WordList wordList) {
        MnemonicValidator validator = new MnemonicValidator(wordList);
        return validator.isValid(mnemonic);
    }

    public static MnemonicValidator.ValidationResult validateMnemonic(String mnemonic) {
        return Bip39.validateMnemonic(mnemonic, DEFAULT_WORDLIST);
    }

    public static MnemonicValidator.ValidationResult validateMnemonic(String mnemonic, WordList wordList) {
        MnemonicValidator validator = new MnemonicValidator(wordList);
        return validator.validate(mnemonic);
    }

    public static byte[] mnemonicToSeed(String mnemonic, String passphrase) {
        return SeedCalculator.calculateSeed(mnemonic, passphrase);
    }

    public static byte[] mnemonicToSeed(String mnemonic) {
        return SeedCalculator.calculateSeed(mnemonic, "");
    }

    public static byte[] wordsToSeed(List<String> words, String passphrase) {
        return SeedCalculator.calculateSeed(words, passphrase);
    }

    public static DeterministicKey mnemonicToMasterKey(String mnemonic, String passphrase) {
        byte[] seed = Bip39.mnemonicToSeed(mnemonic, passphrase);
        return HDKeyDerivation.createMasterPrivateKey(seed);
    }

    public static DeterministicKey mnemonicToMasterKey(String mnemonic) {
        return Bip39.mnemonicToMasterKey(mnemonic, "");
    }

    public static WordList getDefaultWordList() {
        return DEFAULT_WORDLIST;
    }

    public static WordList getWordList(WordList.Language language) {
        return new WordList(language);
    }
}

