/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.bip39;

import java.security.SecureRandom;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip39.WordList;
import xyz.tcheeric.bips.util.Bip39Constants;
import xyz.tcheeric.bips.util.CryptoUtils;
import xyz.tcheeric.bips.util.HexUtils;

public class MnemonicGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MnemonicGenerator.class);
    private final WordList wordList;

    public MnemonicGenerator(WordList wordList) {
        this.wordList = wordList;
    }

    public MnemonicGenerator() {
        this(WordList.english());
    }

    public String generate(byte[] entropy) {
        this.validateEntropyLength(entropy.length * 8);
        StringBuilder mnemonic = new StringBuilder();
        this.createMnemonic(entropy, mnemonic);
        LOGGER.debug("MnemonicGenerator generate_succeeded entropy_bytes={} impact=mnemonic_created", (Object)entropy.length);
        return mnemonic.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateFromHex(String entropyHex) {
        if (entropyHex.length() % 2 != 0) {
            LOGGER.warn("MnemonicGenerator generate_from_hex_failed reason=odd_length hex_length={} impact=mnemonic_not_created", (Object)entropyHex.length());
            throw new IllegalArgumentException("Hex string length must be even");
        }
        byte[] entropy = HexUtils.fromHex(entropyHex);
        try {
            String string = this.generate(entropy);
            return string;
        }
        finally {
            Arrays.fill(entropy, (byte)0);
        }
    }

    public String generateRandom(int wordCount) {
        return this.generateRandom(wordCount, new SecureRandom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRandom(int wordCount, SecureRandom random) {
        int entropyBits = Bip39Constants.wordCountToEntropyBits(wordCount);
        int entropyBytes = entropyBits / 8;
        byte[] entropy = new byte[entropyBytes];
        random.nextBytes(entropy);
        try {
            LOGGER.debug("MnemonicGenerator generate_random_started word_count={} impact=entropy_generated", (Object)wordCount);
            String string = this.generate(entropy);
            return string;
        }
        finally {
            Arrays.fill(entropy, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMnemonic(byte[] entropy, StringBuilder target) {
        int[] wordIndexes = this.calculateWordIndexes(entropy);
        try {
            for (int i2 = 0; i2 < wordIndexes.length; ++i2) {
                if (i2 > 0) {
                    target.append(this.wordList.getSpace());
                }
                target.append(this.wordList.getWord(wordIndexes[i2]));
            }
        }
        finally {
            Arrays.fill(wordIndexes, 0);
        }
    }

    private int[] calculateWordIndexes(byte[] entropy) {
        int entropyBits = entropy.length * 8;
        int checksumBits = entropyBits / 32;
        int totalBits = entropyBits + checksumBits;
        int wordCount = totalBits / 11;
        byte[] entropyWithChecksum = Arrays.copyOf(entropy, entropy.length + 1);
        entropyWithChecksum[entropy.length] = CryptoUtils.sha256FirstByte(entropy);
        int[] wordIndexes = new int[wordCount];
        for (int i2 = 0; i2 < wordCount; ++i2) {
            int bitIndex = i2 * 11;
            wordIndexes[i2] = this.extract11Bits(entropyWithChecksum, bitIndex);
        }
        LOGGER.debug("MnemonicGenerator calculate_word_indexes_succeeded entropy_bytes={} word_count={} impact=indexes_ready", (Object)entropy.length, (Object)wordCount);
        return wordIndexes;
    }

    private int extract11Bits(byte[] data, int bitIndex) {
        int byteIndex = bitIndex / 8;
        int bitOffset = bitIndex % 8;
        int value = 0;
        if (byteIndex < data.length) {
            value = (data[byteIndex] & 0xFF) << 16;
        }
        if (byteIndex + 1 < data.length) {
            value |= (data[byteIndex + 1] & 0xFF) << 8;
        }
        if (byteIndex + 2 < data.length) {
            value |= data[byteIndex + 2] & 0xFF;
        }
        return (value >>= 13 - bitOffset) & 0x7FF;
    }

    private void validateEntropyLength(int entropyBits) {
        if (entropyBits < 128) {
            LOGGER.warn("MnemonicGenerator validate_entropy_failed reason=entropy_too_low entropy_bits={} impact=mnemonic_not_created", (Object)entropyBits);
            throw new IllegalArgumentException("Entropy too low: minimum 128 bits (16 bytes)");
        }
        if (entropyBits > 256) {
            LOGGER.warn("MnemonicGenerator validate_entropy_failed reason=entropy_too_high entropy_bits={} impact=mnemonic_not_created", (Object)entropyBits);
            throw new IllegalArgumentException("Entropy too high: maximum 256 bits (32 bytes)");
        }
        if (entropyBits % 32 != 0) {
            LOGGER.warn("MnemonicGenerator validate_entropy_failed reason=not_divisible entropy_bits={} divisor={} impact=mnemonic_not_created", (Object)entropyBits, (Object)32);
            throw new IllegalArgumentException("Entropy bits must be divisible by 32");
        }
    }

    public WordList getWordList() {
        return this.wordList;
    }
}

