/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.bip39;

import java.util.Arrays;
import java.util.List;
import org.bitcoinj.crypto.MnemonicCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.util.HexUtils;
import xyz.tcheeric.bips.util.MnemonicUtils;

public final class SeedCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeedCalculator.class);

    private SeedCalculator() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static byte[] calculateSeed(String mnemonic, String passphrase) {
        if (mnemonic == null || mnemonic.trim().isEmpty()) {
            LOGGER.warn("SeedCalculator calculate_seed_failed reason=blank_mnemonic impact=seed_not_generated");
            throw new IllegalArgumentException("Mnemonic cannot be null or empty");
        }
        List<String> words = Arrays.asList(MnemonicUtils.splitMnemonic(mnemonic));
        LOGGER.debug("SeedCalculator calculate_seed_started word_count={} impact=pbkdf2_running", (Object)words.size());
        byte[] seed = MnemonicCode.toSeed(words, passphrase != null ? passphrase : "");
        LOGGER.debug("SeedCalculator calculate_seed_succeeded word_count={} impact=seed_generated", (Object)words.size());
        return seed;
    }

    public static byte[] calculateSeed(String mnemonic) {
        return SeedCalculator.calculateSeed(mnemonic, "");
    }

    public static byte[] calculateSeed(List<String> words, String passphrase) {
        if (words == null || words.isEmpty()) {
            LOGGER.warn("SeedCalculator calculate_seed_failed reason=empty_word_list impact=seed_not_generated");
            throw new IllegalArgumentException("Word list cannot be null or empty");
        }
        LOGGER.debug("SeedCalculator calculate_seed_started word_count={} impact=pbkdf2_running", (Object)words.size());
        byte[] seed = MnemonicCode.toSeed(words, passphrase != null ? passphrase : "");
        LOGGER.debug("SeedCalculator calculate_seed_succeeded word_count={} impact=seed_generated", (Object)words.size());
        return seed;
    }

    public static String toHex(byte[] seed) {
        if (seed == null) {
            return null;
        }
        return HexUtils.toHex(seed);
    }
}

