/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.bip39;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WordList {
    private final List<String> words;
    private final Language language;
    private final char space;

    public WordList(Language language) {
        this.language = language;
        this.space = language.getSpaceChar();
        this.words = WordList.loadWordList(language);
        if (this.words.size() != 2048) {
            throw new IllegalStateException("Invalid wordlist for " + String.valueOf((Object)language) + ": expected 2048 words, got " + this.words.size());
        }
    }

    public String getWord(int index) {
        if (index < 0 || index >= 2048) {
            throw new IndexOutOfBoundsException("Word index must be 0-2047, got: " + index);
        }
        return this.words.get(index);
    }

    public int getIndex(String word) {
        return this.words.indexOf(word);
    }

    public boolean contains(String word) {
        return this.words.contains(word);
    }

    public char getSpace() {
        return this.space;
    }

    public Language getLanguage() {
        return this.language;
    }

    public List<String> getWords() {
        return Collections.unmodifiableList(this.words);
    }

    private static List<String> loadWordList(Language language) {
        String resourcePath = "/bip39-wordlists/" + language.getFilename();
        ArrayList<String> wordList = new ArrayList<String>(2048);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(WordList.class.getResourceAsStream(resourcePath), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                wordList.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load wordlist: " + String.valueOf((Object)language), e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Wordlist resource not found: " + resourcePath, e);
        }
        return wordList;
    }

    public static WordList english() {
        return new WordList(Language.ENGLISH);
    }

    public static WordList french() {
        return new WordList(Language.FRENCH);
    }

    public static WordList spanish() {
        return new WordList(Language.SPANISH);
    }

    public static WordList japanese() {
        return new WordList(Language.JAPANESE);
    }

    public static enum Language {
        ENGLISH("english.txt", ' '),
        FRENCH("french.txt", ' '),
        SPANISH("spanish.txt", ' '),
        JAPANESE("japanese.txt", '\u3000');

        private final String filename;
        private final char spaceChar;

        private Language(String filename, char spaceChar) {
            this.filename = filename;
            this.spaceChar = spaceChar;
        }

        public String getFilename() {
            return this.filename;
        }

        public char getSpaceChar() {
            return this.spaceChar;
        }
    }
}

