/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.util;

public final class Bip39Constants {
    public static final int MIN_ENTROPY_BITS = 128;
    public static final int MAX_ENTROPY_BITS = 256;
    public static final int ENTROPY_BITS_DIVISOR = 32;
    public static final int WORD_COUNT_12 = 12;
    public static final int WORD_COUNT_15 = 15;
    public static final int WORD_COUNT_18 = 18;
    public static final int WORD_COUNT_21 = 21;
    public static final int WORD_COUNT_24 = 24;
    public static final int ENTROPY_128_BITS = 128;
    public static final int ENTROPY_160_BITS = 160;
    public static final int ENTROPY_192_BITS = 192;
    public static final int ENTROPY_224_BITS = 224;
    public static final int ENTROPY_256_BITS = 256;
    public static final int BITS_PER_WORD = 11;
    public static final int BITS_PER_BYTE = 8;
    public static final int CHECKSUM_RATIO = 32;
    public static final int WORDLIST_SIZE = 2048;
    public static final int WORD_INDEX_MASK = 2047;

    private Bip39Constants() {
        throw new UnsupportedOperationException("Constants class cannot be instantiated");
    }

    public static int wordCountToEntropyBits(int wordCount) {
        return switch (wordCount) {
            case 12 -> 128;
            case 15 -> 160;
            case 18 -> 192;
            case 21 -> 224;
            case 24 -> 256;
            default -> throw new IllegalArgumentException("Invalid word count: must be 12, 15, 18, 21, or 24, got " + wordCount);
        };
    }

    public static boolean isValidWordCount(int wordCount) {
        return wordCount == 12 || wordCount == 15 || wordCount == 18 || wordCount == 21 || wordCount == 24;
    }
}

