/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class CryptoUtils {
    private static final String SHA_256_ALGORITHM = "SHA-256";

    private CryptoUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static byte[] sha256(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA_256_ALGORITHM);
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static byte sha256FirstByte(byte[] data) {
        byte[] hash = CryptoUtils.sha256(data);
        return hash[0];
    }
}

