/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.util;

public final class HexUtils {
    private HexUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array cannot be null");
        }
        StringBuilder hexBuilder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hexBuilder.append(String.format("%02x", b));
        }
        return hexBuilder.toString();
    }

    public static byte[] fromHex(String hex) {
        if (hex == null || hex.isEmpty()) {
            throw new IllegalArgumentException("Hex string cannot be null or empty");
        }
        String normalizedHex = hex.trim();
        if (normalizedHex.toLowerCase().startsWith("0x")) {
            normalizedHex = normalizedHex.substring(2);
        }
        if (normalizedHex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have even length, got: " + normalizedHex.length());
        }
        byte[] bytes = new byte[normalizedHex.length() / 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int index = i2 * 2;
            String byteString = normalizedHex.substring(index, index + 2);
            bytes[i2] = (byte)Integer.parseInt(byteString, 16);
        }
        return bytes;
    }
}

