/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.bips.util;

public final class MnemonicUtils {
    private static final char IDEOGRAPHIC_SPACE = '\u3000';
    private static final char REGULAR_SPACE = ' ';

    private MnemonicUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String normalizeMnemonic(String mnemonic) {
        if (mnemonic == null || mnemonic.trim().isEmpty()) {
            throw new IllegalArgumentException("Mnemonic cannot be null or empty");
        }
        return mnemonic.trim().replaceAll("\\s+", String.valueOf(' ')).replace('\u3000', ' ');
    }

    public static String[] splitMnemonic(String mnemonic) {
        String normalized = MnemonicUtils.normalizeMnemonic(mnemonic);
        return normalized.split(String.valueOf(' '));
    }
}

