/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.SecretDerivationPath;
import xyz.tcheeric.cashu.common.json.deserializer.DeterministicSecretDeserializer;

@JsonDeserialize(using=DeterministicSecretDeserializer.class)
public class DeterministicSecret
extends BaseKey
implements Secret {
    private final SecretDerivationPath derivationPath;
    private final KeysetId keysetId;
    private final int counter;

    private DeterministicSecret(@NonNull byte[] derivedBytes) {
        this(derivedBytes, null, null, 0);
        if (derivedBytes == null) {
            throw new NullPointerException("derivedBytes is marked non-null but is null");
        }
    }

    private DeterministicSecret(@NonNull byte[] derivedBytes, KeysetId keysetId, SecretDerivationPath derivationPath, int counter) {
        super(derivedBytes);
        if (derivedBytes == null) {
            throw new NullPointerException("derivedBytes is marked non-null but is null");
        }
        this.keysetId = keysetId;
        this.counter = counter;
        this.derivationPath = derivationPath;
        if (derivationPath != null && keysetId != null) {
            if (!derivationPath.getKeysetId().equals(keysetId)) {
                throw new IllegalArgumentException("Derivation path keyset ID does not match provided keyset ID");
            }
            if (derivationPath.getCounter() != counter) {
                throw new IllegalArgumentException("Derivation path counter does not match provided counter");
            }
        }
    }

    public static DeterministicSecret fromString(@NonNull String hexString) {
        if (hexString == null) {
            throw new NullPointerException("hexString is marked non-null but is null");
        }
        byte[] bytes = Hex.decode(hexString);
        return new DeterministicSecret(bytes);
    }

    public static DeterministicSecret fromBytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new DeterministicSecret(bytes);
    }

    public static DeterministicSecret create(@NonNull byte[] derivedBytes, @NonNull KeysetId keysetId, int counter) {
        if (derivedBytes == null) {
            throw new NullPointerException("derivedBytes is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        SecretDerivationPath path = new SecretDerivationPath();
        path.setKeysetId(keysetId);
        path.setCounter(counter);
        return new DeterministicSecret(derivedBytes, keysetId, path, counter);
    }

    public static DeterministicSecret create(@NonNull byte[] derivedBytes, @NonNull SecretDerivationPath derivationPath) {
        if (derivedBytes == null) {
            throw new NullPointerException("derivedBytes is marked non-null but is null");
        }
        if (derivationPath == null) {
            throw new NullPointerException("derivationPath is marked non-null but is null");
        }
        return new DeterministicSecret(derivedBytes, derivationPath.getKeysetId(), derivationPath, derivationPath.getCounter());
    }

    @Override
    public byte[] getData() {
        return this.getBytes();
    }

    @Override
    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        throw new UnsupportedOperationException("DeterministicSecret is immutable. Cannot modify secret data after creation.");
    }

    public boolean hasMetadata() {
        return this.keysetId != null && this.derivationPath != null;
    }

    @Override
    @JsonValue
    public String toString() {
        return super.toString();
    }

    public String toStringWithMetadata() {
        String hexString = this.toString();
        if (this.hasMetadata()) {
            return String.format("%s (keyset=%s, counter=%d, path=%s)", hexString, this.keysetId, this.counter, this.derivationPath);
        }
        return hexString;
    }

    public String toHexString() {
        return this.toString();
    }

    @Generated
    public SecretDerivationPath getDerivationPath() {
        return this.derivationPath;
    }

    @Generated
    public KeysetId getKeysetId() {
        return this.keysetId;
    }

    @Generated
    public int getCounter() {
        return this.counter;
    }
}

