/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.SecretUtil;

public class HashToCurveSecret {
    private final CompressedPublicKey publicKey;

    public HashToCurveSecret(@NonNull Secret secret) {
        this((CompressedPublicKey)PublicKey.fromString(SecretUtil.toY(secret), true));
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
    }

    public HashToCurveSecret(@NonNull Proof proof) {
        this((Secret)proof.getSecret());
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
    }

    HashToCurveSecret(@NonNull CompressedPublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static HashToCurveSecret fromString(@NonNull String htcs) {
        if (htcs == null) {
            throw new NullPointerException("htcs is marked non-null but is null");
        }
        CompressedPublicKey publicKey = CompressedPublicKey.fromString(htcs);
        return new HashToCurveSecret(publicKey);
    }

    @JsonValue
    public String toJson() {
        return this.publicKey.toString();
    }

    public String toString() {
        return this.toJson();
    }
}

