/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.WellKnownSecret;
import xyz.tcheeric.cashu.common.util.JsonUtils;

public class P2PKSecret
extends WellKnownSecret {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(P2PKSecret.class);

    public P2PKSecret() {
        super(WellKnownSecret.Kind.P2PK);
    }

    public P2PKSecret(@NonNull byte[] data) {
        super(WellKnownSecret.Kind.P2PK, data);
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.setNSigs(1);
        this.setSigFlag(SignatureFlag.SIG_INPUTS);
    }

    public P2PKSecret(@NonNull byte[] data, int nSigs, @NonNull SignatureFlag sigFlag) {
        super(WellKnownSecret.Kind.P2PK, data);
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (sigFlag == null) {
            throw new NullPointerException("sigFlag is marked non-null but is null");
        }
        this.setNSigs(nSigs);
        this.setSigFlag(sigFlag);
    }

    public void addTag(@NonNull P2PKTag tag, @NonNull List<Object> values2) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (values2 == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        super.addTag(tag.name(), values2);
    }

    public void setSigFlag(@NonNull SignatureFlag sigFlag) {
        if (sigFlag == null) {
            throw new NullPointerException("sigFlag is marked non-null but is null");
        }
        super.setTag(P2PKTag.sigflag.name(), List.of(sigFlag));
    }

    public void setNSigs(@NonNull Integer nSigs) {
        if (nSigs == null) {
            throw new NullPointerException("nSigs is marked non-null but is null");
        }
        super.setTag(P2PKTag.n_sigs.name(), List.of(nSigs));
    }

    public void setPubKeys(@NonNull List<String> pubKeys) {
        if (pubKeys == null) {
            throw new NullPointerException("pubKeys is marked non-null but is null");
        }
        super.setTag(P2PKTag.pubkeys.name(), new ArrayList<Object>(pubKeys.stream().toList()));
    }

    public void addPubKey(@NonNull String pubKey) {
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        List<String> pubKeys = this.getPubKeys();
        pubKeys.add(pubKey);
        this.setPubKeys(pubKeys);
    }

    public void setLockTime(@NonNull Integer lockTime) {
        if (lockTime == null) {
            throw new NullPointerException("lockTime is marked non-null but is null");
        }
        super.setTag(P2PKTag.locktime.name(), List.of(lockTime));
    }

    public void setRefund(@NonNull List<String> refund) {
        if (refund == null) {
            throw new NullPointerException("refund is marked non-null but is null");
        }
        super.setTag(P2PKTag.refund.name(), new ArrayList<Object>(refund.stream().toList()));
    }

    public void addRefund(@NonNull String refund) {
        if (refund == null) {
            throw new NullPointerException("refund is marked non-null but is null");
        }
        List<String> refunds = this.getRefund();
        refunds.add(refund);
        this.setRefund(refunds);
    }

    public int getNSigs() {
        WellKnownSecret.Tag tag = super.getTag(P2PKTag.n_sigs.name());
        if (tag == null) {
            return -1;
        }
        List<Object> values2 = super.getTag(P2PKTag.n_sigs.name()).getValues();
        return values2 != null ? (Integer)values2.get(0) : -1;
    }

    public String getSigFlag() {
        WellKnownSecret.Tag tag = super.getTag(P2PKTag.sigflag.name());
        if (tag == null) {
            return null;
        }
        List<Object> values2 = super.getTag(P2PKTag.sigflag.name()).getValues();
        return values2 != null ? ((SignatureFlag)((Object)values2.get(0))).name() : null;
    }

    public List<String> getPubKeys() {
        WellKnownSecret.Tag tag = super.getTag(P2PKTag.pubkeys.name());
        if (tag == null) {
            return new ArrayList<String>();
        }
        ArrayList values2 = tag.getValues();
        return values2 != null ? values2 : new ArrayList();
    }

    public int getLockTime() {
        WellKnownSecret.Tag tag = super.getTag(P2PKTag.locktime.name());
        if (tag == null) {
            return 0;
        }
        List<Object> values2 = super.getTag(P2PKTag.locktime.name()).getValues();
        return values2 != null ? (Integer)values2.get(0) : 0;
    }

    public List<String> getRefund() {
        WellKnownSecret.Tag tag = super.getTag(P2PKTag.refund.name());
        if (tag == null) {
            return new ArrayList<String>();
        }
        ArrayList values2 = super.getTag(P2PKTag.refund.name()).getValues();
        return values2 != null ? values2 : new ArrayList();
    }

    @Deprecated(forRemoval=true)
    public static P2PKSecret fromString(@NonNull String secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        return JsonUtils.JSON_MAPPER.readValue(secret, P2PKSecret.class);
    }

    public static enum SignatureFlag {
        SIG_INPUTS,
        SIG_ALL;

    }

    public static enum P2PKTag {
        sigflag,
        n_sigs,
        pubkeys,
        locktime,
        refund;

    }
}

