/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.crypto.util.KeysUtils;

public class PrivateKey
extends BaseKey {
    protected PrivateKey(@NonNull String value) {
        this(Hex.decode(value));
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    protected PrivateKey(byte[] value) {
        super(value);
        if (value.length != 32) {
            throw new IllegalArgumentException("Invalid private key length. (" + value.length + ")");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PrivateKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new PrivateKey(s);
    }

    public static PrivateKey fromBytes(byte[] bytes) {
        return new PrivateKey(bytes);
    }

    public static PublicKey derivePublicKey(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return PublicKey.fromString(Hex.toHexString(KeysUtils.derivePublicKey(privateKey.getBytes())));
    }

    public static PrivateKey generateRandom() {
        return PrivateKey.fromBytes(KeysUtils.generatePrivateKey());
    }
}

