/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.UnCompressedPublicKey;

public class PublicKey
extends BaseKey {
    private Object data;

    @Deprecated(forRemoval=true)
    protected PublicKey(@NonNull Object data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        if (data instanceof String) {
            this.setBytes(Hex.decode((String)data));
        } else if (data instanceof byte[]) {
            this.setBytes((byte[])data);
        } else {
            throw new IllegalArgumentException("data must be String or byte[]");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PublicKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new CompressedPublicKey(s);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PublicKey fromBytes(byte[] bytes) {
        return new CompressedPublicKey(bytes);
    }

    public static PublicKey fromPoint(ECPoint ecPoint) {
        return PublicKey.fromPoint(ecPoint, true);
    }

    public static PublicKey fromBytes(byte[] bytes, boolean compressed) {
        return compressed ? new CompressedPublicKey(bytes) : new UnCompressedPublicKey(bytes);
    }

    public static PublicKey fromString(String str, boolean compressed) {
        return compressed ? new CompressedPublicKey(str) : new UnCompressedPublicKey(str);
    }

    public static PublicKey fromPoint(ECPoint ecPoint, boolean compressed) {
        byte[] bytes = ecPoint.getEncoded(compressed);
        if (compressed) {
            return PublicKey.fromBytes(bytes, true);
        }
        byte[] uncompressed = Arrays.copyOfRange(bytes, 1, bytes.length);
        return PublicKey.fromBytes(uncompressed, false);
    }

    public byte[] getSchnorr() {
        return Hex.decode(this.toString().substring(2));
    }

    public static byte[] getSchnorr(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return publicKey.getSchnorr();
    }

    public static PublicKey derivePublicKey(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return PrivateKey.derivePublicKey(privateKey);
    }

    public static PublicKey derivePublicKey(@NonNull String privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return PublicKey.derivePublicKey(PrivateKey.fromString(privateKey));
    }

    protected static byte[] toFixed32(byte[] src) {
        if (src.length == 32) {
            return src;
        }
        byte[] out = new byte[32];
        if (src.length > 32) {
            System.arraycopy(src, src.length - 32, out, 0, 32);
        } else {
            System.arraycopy(src, 0, out, 32 - src.length, src.length);
        }
        return out;
    }

    @Generated
    protected PublicKey() {
    }
}

