/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.RandomStringSecret;

public interface Secret {
    public byte[] getData();

    public void setData(@NonNull byte[] var1);

    public byte[] toBytes();

    @Deprecated(forRemoval=true)
    public static Secret fromString(@NonNull String secret, @NonNull Class<?> type) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return switch (type.getSimpleName()) {
            case "P2PKSecret" -> P2PKSecret.fromString(secret);
            case "RandomStringSecret" -> RandomStringSecret.fromString(secret);
            case "DeterministicSecret" -> DeterministicSecret.fromString(secret);
            default -> throw new IllegalArgumentException("Unknown secret type: " + type.getSimpleName());
        };
    }
}

