/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.UnCompressedPublicKey;
import xyz.tcheeric.cashu.common.json.deserializer.SignatureJsonDeserializer;
import xyz.tcheeric.cashu.common.json.serializer.SignatureJsonSerializer;
import xyz.tcheeric.cashu.crypto.Schnorr;

@JsonSerialize(using=SignatureJsonSerializer.class)
@JsonDeserialize(using=SignatureJsonDeserializer.class)
public class Signature {
    private final PublicKey publicKey;
    private static final int SIGNATURE_LENGTH = 128;

    protected Signature(@NonNull String compressed) {
        if (compressed == null) {
            throw new NullPointerException("compressed is marked non-null but is null");
        }
        this.publicKey = new CompressedPublicKey(compressed);
        if (compressed.length() != 66) {
            throw new IllegalArgumentException("Invalid signature length");
        }
    }

    protected Signature(byte[] uncompressed) {
        this.publicKey = new UnCompressedPublicKey(uncompressed);
        if (uncompressed.length != 64) {
            throw new IllegalArgumentException("Invalid signature length (" + uncompressed.length + ")");
        }
    }

    public byte[] getBytes() {
        return this.publicKey.getBytes();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Signature fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new Signature(s);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Signature fromBytes(byte[] bytes) {
        return new Signature(bytes);
    }

    @JsonValue
    public String toString() {
        return this.publicKey.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return this.publicKey.toString().equals(other.publicKey.toString());
    }

    public int hashCode() {
        return this.publicKey.toString().hashCode();
    }

    public static Signature sign(@NonNull String message, @NonNull PrivateKey privateKey) throws Exception {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        byte[] signature = Schnorr.sign(message.getBytes(StandardCharsets.UTF_8), privateKey.getBytes());
        return Signature.fromBytes(signature);
    }

    public static boolean verify(@NonNull String message, @NonNull PublicKey publicKey, @NonNull Signature signature) throws Exception {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return Schnorr.verify(message.getBytes(StandardCharsets.UTF_8), publicKey.getSchnorr(), signature.getBytes());
    }

    public boolean verify(@NonNull String message, @NonNull PublicKey publicKey) throws Exception {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return Signature.verify(message, publicKey, this);
    }
}

