/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Token;
import xyz.tcheeric.cashu.common.util.JsonUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TokenV3<T extends Secret>
implements Token {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenV3.class);
    @JsonProperty(value="token")
    private Set<MintProof<T>> mintProofs = new HashSet<MintProof<T>>();
    @JsonProperty(value="unit")
    private String unit;
    @JsonProperty(value="memo")
    private String memo;

    @Override
    public String serialize(boolean clickable) {
        ObjectMapper objectMapper = JsonUtils.JSON_MAPPER;
        try {
            log.debug("Serializing TokenV3 containing {} mint proofs", (Object)this.mintProofs.size());
            byte[] json = objectMapper.writeValueAsBytes(this);
            return Token.TokenUtil.serialize(json, Token.Version.V3, clickable);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMintProof(@NonNull MintProof<T> mintProof) {
        if (mintProof == null) {
            throw new NullPointerException("mintProof is marked non-null but is null");
        }
        MintProof existingMintProof = this.mintProofs.stream().filter(mp -> mp.getMint().equals(mintProof.getMint())).findFirst().orElse(null);
        if (existingMintProof == null) {
            this.mintProofs.add(mintProof);
        } else {
            existingMintProof.getProofs().addAll(mintProof.getProofs());
        }
    }

    public static TokenV3 deserialize(String serializedToken) {
        if (serializedToken.startsWith("cashu:")) {
            serializedToken = serializedToken.substring("cashu:".length());
        }
        if (!serializedToken.startsWith("cashu" + Token.Version.V3.getCode())) {
            throw new IllegalArgumentException("Invalid token format");
        }
        serializedToken = serializedToken.substring("cashu".length() + Token.Version.V3.getCode().toString().length());
        byte[] byteArrToken = Base64.getUrlDecoder().decode(serializedToken);
        ObjectMapper objectMapper = JsonUtils.JSON_MAPPER;
        try {
            TokenV3 token = objectMapper.readValue(byteArrToken, TokenV3.class);
            log.debug("Deserialized TokenV3 with {} mint proofs", (Object)token.getMintProofs().size());
            return token;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public Set<MintProof<T>> getMintProofs() {
        return this.mintProofs;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public String getMemo() {
        return this.memo;
    }

    @Generated
    public void setMintProofs(Set<MintProof<T>> mintProofs) {
        this.mintProofs = mintProofs;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenV3)) {
            return false;
        }
        TokenV3 other = (TokenV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<MintProof<T>> this$mintProofs = this.getMintProofs();
        Set<MintProof<T>> other$mintProofs = other.getMintProofs();
        if (this$mintProofs == null ? other$mintProofs != null : !((Object)this$mintProofs).equals(other$mintProofs)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        return !(this$memo == null ? other$memo != null : !this$memo.equals(other$memo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TokenV3;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<MintProof<T>> $mintProofs = this.getMintProofs();
        result = result * 59 + ($mintProofs == null ? 43 : ((Object)$mintProofs).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenV3(mintProofs=" + String.valueOf(this.getMintProofs()) + ", unit=" + this.getUnit() + ", memo=" + this.getMemo() + ")";
    }

    @Generated
    public TokenV3() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MintProof<T extends Secret> {
        @JsonProperty(value="mint")
        private String mint;
        @JsonProperty(value="proofs")
        private Set<Proof<T>> proofs = new LinkedHashSet<Proof<T>>();

        public boolean addProof(@NonNull Proof<T> proof) {
            if (proof == null) {
                throw new NullPointerException("proof is marked non-null but is null");
            }
            return this.proofs.add(proof);
        }

        public boolean removeProof(@NonNull Proof<T> proof) {
            if (proof == null) {
                throw new NullPointerException("proof is marked non-null but is null");
            }
            return this.proofs.remove(proof);
        }

        public void setProofs(@NonNull Set<Proof<T>> proofs) {
            if (proofs == null) {
                throw new NullPointerException("proofs is marked non-null but is null");
            }
            ArrayList<Proof<T>> list = new ArrayList<Proof<T>>(proofs);
            list.sort(Comparator.comparingInt(Proof::getAmount));
            this.proofs = new LinkedHashSet<Proof<T>>(list);
        }

        @Generated
        public String getMint() {
            return this.mint;
        }

        @Generated
        public Set<Proof<T>> getProofs() {
            return this.proofs;
        }

        @Generated
        public void setMint(String mint) {
            this.mint = mint;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MintProof)) {
                return false;
            }
            MintProof other = (MintProof)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mint = this.getMint();
            String other$mint = other.getMint();
            if (this$mint == null ? other$mint != null : !this$mint.equals(other$mint)) {
                return false;
            }
            Set<Proof<T>> this$proofs = this.getProofs();
            Set<Proof<T>> other$proofs = other.getProofs();
            return !(this$proofs == null ? other$proofs != null : !((Object)this$proofs).equals(other$proofs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MintProof;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mint = this.getMint();
            result = result * 59 + ($mint == null ? 43 : $mint.hashCode());
            Set<Proof<T>> $proofs = this.getProofs();
            result = result * 59 + ($proofs == null ? 43 : ((Object)$proofs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TokenV3.MintProof(mint=" + this.getMint() + ", proofs=" + String.valueOf(this.getProofs()) + ")";
        }

        @Generated
        public MintProof() {
        }
    }
}

