/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Token;
import xyz.tcheeric.cashu.common.util.JsonUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"t", "d", "m", "u"})
public class TokenV4
implements Token {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenV4.class);
    @JsonProperty(value="m")
    private String mintUrl;
    @JsonProperty(value="u")
    private String unit;
    @JsonProperty(value="d")
    private String memo;
    @JsonProperty(value="t")
    private List<TokenData> tokenDataList = new ArrayList<TokenData>();

    public void setMintUrl(String mintUrl) {
        this.mintUrl = mintUrl != null ? mintUrl.replaceAll("/+$", "") : null;
    }

    @Override
    public String serialize(boolean clickable) {
        try {
            log.debug("Serializing TokenV4 with {} token data entries", (Object)this.tokenDataList.size());
            byte[] cborToken = JsonUtils.CBOR_MAPPER.writeValueAsBytes(this);
            return Token.TokenUtil.serialize(cborToken, Token.Version.V4, clickable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TokenV4 deserialize(@NonNull String serializedToken) {
        if (serializedToken == null) {
            throw new NullPointerException("serializedToken is marked non-null but is null");
        }
        if (serializedToken.startsWith("cashu:")) {
            serializedToken = serializedToken.substring("cashu:".length());
        }
        if (!serializedToken.startsWith("cashu" + Token.Version.V4.getCode())) {
            throw new IllegalArgumentException("Invalid token format");
        }
        serializedToken = serializedToken.substring("cashu".length() + Token.Version.V4.getCode().toString().length());
        byte[] cborToken = Base64.getUrlDecoder().decode(serializedToken);
        ObjectMapper objectMapper = JsonUtils.CBOR_MAPPER;
        try {
            TokenV4 token = objectMapper.readValue(cborToken, TokenV4.class);
            log.debug("Deserialized TokenV4 with {} token data entries", (Object)token.getTokenDataList().size());
            return token;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public String getMintUrl() {
        return this.mintUrl;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public String getMemo() {
        return this.memo;
    }

    @Generated
    public List<TokenData> getTokenDataList() {
        return this.tokenDataList;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Generated
    public void setTokenDataList(List<TokenData> tokenDataList) {
        this.tokenDataList = tokenDataList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenV4)) {
            return false;
        }
        TokenV4 other = (TokenV4)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mintUrl = this.getMintUrl();
        String other$mintUrl = other.getMintUrl();
        if (this$mintUrl == null ? other$mintUrl != null : !this$mintUrl.equals(other$mintUrl)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        List<TokenData> this$tokenDataList = this.getTokenDataList();
        List<TokenData> other$tokenDataList = other.getTokenDataList();
        return !(this$tokenDataList == null ? other$tokenDataList != null : !((Object)this$tokenDataList).equals(other$tokenDataList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TokenV4;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mintUrl = this.getMintUrl();
        result = result * 59 + ($mintUrl == null ? 43 : $mintUrl.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        List<TokenData> $tokenDataList = this.getTokenDataList();
        result = result * 59 + ($tokenDataList == null ? 43 : ((Object)$tokenDataList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenV4(mintUrl=" + this.getMintUrl() + ", unit=" + this.getUnit() + ", memo=" + this.getMemo() + ", tokenDataList=" + String.valueOf(this.getTokenDataList()) + ")";
    }

    @Generated
    public TokenV4() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"i", "p"})
    public static class TokenData {
        @JsonProperty(value="i")
        private byte[] keySetId;
        @JsonProperty(value="p")
        private List<TokenProof> proofs = new ArrayList<TokenProof>();

        public void addProofs(TokenProof ... proofs) {
            if (proofs == null) {
                throw new NullPointerException("proofs is marked non-null but is null");
            }
            Collections.addAll(this.proofs, proofs);
        }

        @Generated
        public byte[] getKeySetId() {
            return this.keySetId;
        }

        @Generated
        public List<TokenProof> getProofs() {
            return this.proofs;
        }

        @Generated
        public void setKeySetId(byte[] keySetId) {
            this.keySetId = keySetId;
        }

        @Generated
        public void setProofs(List<TokenProof> proofs) {
            this.proofs = proofs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenData)) {
                return false;
            }
            TokenData other = (TokenData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getKeySetId(), other.getKeySetId())) {
                return false;
            }
            List<TokenProof> this$proofs = this.getProofs();
            List<TokenProof> other$proofs = other.getProofs();
            return !(this$proofs == null ? other$proofs != null : !((Object)this$proofs).equals(other$proofs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TokenData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getKeySetId());
            List<TokenProof> $proofs = this.getProofs();
            result = result * 59 + ($proofs == null ? 43 : ((Object)$proofs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TokenV4.TokenData(keySetId=" + Arrays.toString(this.getKeySetId()) + ", proofs=" + String.valueOf(this.getProofs()) + ")";
        }

        @Generated
        public TokenData() {
        }

        @Generated
        public TokenData(byte[] keySetId, List<TokenProof> proofs) {
            this.keySetId = keySetId;
            this.proofs = proofs;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonPropertyOrder(value={"a", "s", "c", "d", "w"})
        public static class TokenProof {
            @JsonProperty(value="a")
            private Integer amount;
            @JsonProperty(value="s")
            private String secret;
            @JsonProperty(value="c")
            private byte[] signature;
            @JsonProperty(value="d")
            private DLEQProof dleqProof;
            @JsonProperty(value="w")
            private String witness;

            @Generated
            public Integer getAmount() {
                return this.amount;
            }

            @Generated
            public String getSecret() {
                return this.secret;
            }

            @Generated
            public byte[] getSignature() {
                return this.signature;
            }

            @Generated
            public DLEQProof getDleqProof() {
                return this.dleqProof;
            }

            @Generated
            public String getWitness() {
                return this.witness;
            }

            @Generated
            public void setAmount(Integer amount) {
                this.amount = amount;
            }

            @Generated
            public void setSecret(String secret) {
                this.secret = secret;
            }

            @Generated
            public void setSignature(byte[] signature) {
                this.signature = signature;
            }

            @Generated
            public void setDleqProof(DLEQProof dleqProof) {
                this.dleqProof = dleqProof;
            }

            @Generated
            public void setWitness(String witness) {
                this.witness = witness;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TokenProof)) {
                    return false;
                }
                TokenProof other = (TokenProof)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$amount = this.getAmount();
                Integer other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$secret = this.getSecret();
                String other$secret = other.getSecret();
                if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
                    return false;
                }
                if (!Arrays.equals(this.getSignature(), other.getSignature())) {
                    return false;
                }
                DLEQProof this$dleqProof = this.getDleqProof();
                DLEQProof other$dleqProof = other.getDleqProof();
                if (this$dleqProof == null ? other$dleqProof != null : !((Object)this$dleqProof).equals(other$dleqProof)) {
                    return false;
                }
                String this$witness = this.getWitness();
                String other$witness = other.getWitness();
                return !(this$witness == null ? other$witness != null : !this$witness.equals(other$witness));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TokenProof;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $secret = this.getSecret();
                result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
                result = result * 59 + Arrays.hashCode(this.getSignature());
                DLEQProof $dleqProof = this.getDleqProof();
                result = result * 59 + ($dleqProof == null ? 43 : ((Object)$dleqProof).hashCode());
                String $witness = this.getWitness();
                result = result * 59 + ($witness == null ? 43 : $witness.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "TokenV4.TokenData.TokenProof(amount=" + this.getAmount() + ", secret=" + this.getSecret() + ", signature=" + Arrays.toString(this.getSignature()) + ", dleqProof=" + String.valueOf(this.getDleqProof()) + ", witness=" + this.getWitness() + ")";
            }

            @Generated
            public TokenProof() {
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonPropertyOrder(value={"e", "s", "r"})
            public static class DLEQProof {
                @JsonProperty(value="e")
                private byte[] e;
                @JsonProperty(value="s")
                private byte[] s;
                @JsonProperty(value="r")
                private byte[] r;

                @Generated
                public byte[] getE() {
                    return this.e;
                }

                @Generated
                public byte[] getS() {
                    return this.s;
                }

                @Generated
                public byte[] getR() {
                    return this.r;
                }

                @Generated
                public void setE(byte[] e) {
                    this.e = e;
                }

                @Generated
                public void setS(byte[] s) {
                    this.s = s;
                }

                @Generated
                public void setR(byte[] r) {
                    this.r = r;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof DLEQProof)) {
                        return false;
                    }
                    DLEQProof other = (DLEQProof)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!Arrays.equals(this.getE(), other.getE())) {
                        return false;
                    }
                    if (!Arrays.equals(this.getS(), other.getS())) {
                        return false;
                    }
                    return Arrays.equals(this.getR(), other.getR());
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof DLEQProof;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + Arrays.hashCode(this.getE());
                    result = result * 59 + Arrays.hashCode(this.getS());
                    result = result * 59 + Arrays.hashCode(this.getR());
                    return result;
                }

                @Generated
                public String toString() {
                    return "TokenV4.TokenData.TokenProof.DLEQProof(e=" + Arrays.toString(this.getE()) + ", s=" + Arrays.toString(this.getS()) + ", r=" + Arrays.toString(this.getR()) + ")";
                }

                @Generated
                public DLEQProof() {
                }
            }
        }
    }
}

