/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.crypto.util.Point;

public class UnCompressedPublicKey
extends PublicKey {
    UnCompressedPublicKey(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        this.setBytes(bytes);
        if (bytes.length != 64) {
            throw new IllegalArgumentException("Invalid uncompressed public key length (" + bytes.length + ")");
        }
    }

    UnCompressedPublicKey(@NonNull String s) {
        this(Hex.decode(s));
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static UnCompressedPublicKey fromBytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new UnCompressedPublicKey(bytes);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static UnCompressedPublicKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new UnCompressedPublicKey(s);
    }

    @Override
    public String toString() {
        return UnCompressedPublicKey.compress(this).toString();
    }

    static CompressedPublicKey compress(UnCompressedPublicKey unCompressedPublicKey) {
        Point point = new Point(Hex.toHexString(unCompressedPublicKey.getBytes()));
        String prefix = point.hasEvenY() ? "02" : "03";
        byte[] bytes = UnCompressedPublicKey.toFixed32(point.getX().toByteArray());
        return CompressedPublicKey.fromString(prefix + Hex.toHexString(bytes));
    }
}

