/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.PublicKey;

public class KeysDeserializer
extends JsonDeserializer<Keys> {
    @Override
    public Keys deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.isObject()) {
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            Map<String, String> map = mapper.readValue(node.toString(), new TypeReference<Map<String, String>>(this){});
            Keys keys2 = new Keys();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                keys2.put(new BigInteger(entry.getKey()), PublicKey.fromString(entry.getValue()));
            }
            return keys2;
        }
        throw new RuntimeException("Invalid Keys format");
    }
}

