/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.deserializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.WellKnownSecret;

public class TagDeserializer
extends JsonDeserializer<WellKnownSecret.Tag> {
    @Override
    public WellKnownSecret.Tag deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        String key = node.get(0).textValue();
        WellKnownSecret.Tag tag = new WellKnownSecret.Tag(key);
        switch (P2PKSecret.P2PKTag.valueOf(key.toLowerCase())) {
            case sigflag: {
                tag.addValue((Object)P2PKSecret.SignatureFlag.valueOf(node.get(1).textValue()));
                break;
            }
            case pubkeys: 
            case refund: {
                for (int i2 = 1; i2 < node.size(); ++i2) {
                    tag.addValue(node.get(i2).textValue());
                }
                break;
            }
            case n_sigs: 
            case locktime: {
                tag.addValue(node.get(1).intValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag");
            }
        }
        return tag;
    }
}

