/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.WellKnownSecret;

public class TagSerializer
extends JsonSerializer<WellKnownSecret.Tag> {
    @Override
    public void serialize(WellKnownSecret.Tag value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartArray();
        gen.writeString(value.getKey());
        if (value.getValues() != null) {
            for (Object v : value.getValues()) {
                if (v instanceof String) {
                    String s = (String)v;
                    gen.writeString(s);
                    continue;
                }
                if (v instanceof Integer) {
                    Integer i2 = (Integer)v;
                    gen.writeNumber(i2);
                    continue;
                }
                if (v instanceof P2PKSecret.SignatureFlag) {
                    P2PKSecret.SignatureFlag f = (P2PKSecret.SignatureFlag)((Object)v);
                    gen.writeString(f.name());
                    continue;
                }
                gen.writeString(String.valueOf(v));
            }
        }
        gen.writeEndArray();
    }
}

