/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.crypto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.crypto.util.KeysUtils;
import xyz.tcheeric.cashu.crypto.util.Utils;

public class BDHKEUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BDHKEUtils.class);
    private static final byte[] DOMAIN_SEPARATOR = "Secp256k1_HashToCurve_Cashu_".getBytes(StandardCharsets.UTF_8);
    private static final SecP256K1Curve CURVE = new SecP256K1Curve();

    public static byte[] hashToCurve(String secret) {
        if (secret == null || secret.isEmpty()) {
            throw new IllegalArgumentException("secret must not be null or empty");
        }
        ECPoint result = BDHKEUtils.hashToCurve(Utils.hexStringToBytes(secret));
        return result.getEncoded(true);
    }

    public static ECPoint hashToCurve(byte[] secret) {
        MessageDigest sha256;
        if (secret == null || secret.length == 0) {
            throw new IllegalArgumentException("secret must not be null or empty");
        }
        log.debug("hashToCurve invoked with secret length {}", (Object)secret.length);
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] secretToHash = sha256.digest(BDHKEUtils.concat(DOMAIN_SEPARATOR, secret));
        for (long counter = 0L; counter <= 0xFFFFFFFFL; ++counter) {
            byte[] counterBytes = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt((int)counter).array();
            byte[] hash = sha256.digest(BDHKEUtils.concat(secretToHash, counterBytes));
            byte[] pkHash = BDHKEUtils.concat({2}, hash);
            try {
                ECPoint publicKey = CURVE.decodePoint(pkHash);
                if (!publicKey.isValid()) continue;
                return publicKey;
            }
            catch (IllegalArgumentException e) {
                log.debug("Invalid point derived at counter {}. Retrying...", (Object)counter);
            }
        }
        throw new RuntimeException("No valid point found");
    }

    public static byte[][] blindMessage(byte[] secret) {
        byte[][] result = new byte[2][];
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec("secp256k1");
        BigInteger r = Utils.bigIntFromBytes(KeysUtils.generatePrivateKey());
        ECPoint G = spec.getG();
        ECPoint Y = BDHKEUtils.hashToCurve(secret);
        ECPoint rG = G.multiply(r);
        ECPoint B_ = Y.add(rG);
        byte[] uncompressed = B_.getEncoded(false);
        result[0] = Arrays.copyOfRange(uncompressed, 1, uncompressed.length);
        result[1] = Utils.bytesFromBigInteger(r);
        return result;
    }

    public static byte[] blindMessage(byte[] secret, byte[] r) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec("secp256k1");
        ECPoint G = spec.getG();
        ECPoint Y = BDHKEUtils.hashToCurve(secret);
        ECPoint rG = G.multiply(Utils.bigIntFromBytes(r));
        ECPoint B_ = Y.add(rG);
        byte[] uncompressed = B_.getEncoded(false);
        return Arrays.copyOfRange(uncompressed, 1, uncompressed.length);
    }

    public static byte[] signBlindedMessage(byte[] B_, byte[] k) {
        byte[] sec1 = B_ != null && B_.length == 64 ? BDHKEUtils.concat({4}, B_) : B_;
        return BDHKEUtils.signBlindedMessage(CURVE.decodePoint(sec1), Utils.bigIntFromBytes(k)).getEncoded(true);
    }

    public static ECPoint signBlindedMessage(@NonNull ECPoint B_, @NonNull BigInteger k) {
        if (B_ == null) {
            throw new NullPointerException("B_ is marked non-null but is null");
        }
        if (k == null) {
            throw new NullPointerException("k is marked non-null but is null");
        }
        ECPoint C_ = B_.multiply(k);
        return C_;
    }

    public static byte[] unblindSignature(byte[] C_, byte[] r, byte[] K) {
        return BDHKEUtils.unblindSignature(CURVE.decodePoint(C_), Utils.bigIntFromBytes(r), CURVE.decodePoint(K)).getEncoded(true);
    }

    public static ECPoint unblindSignature(@NonNull ECPoint C_, @NonNull BigInteger r, @NonNull ECPoint K) {
        if (C_ == null) {
            throw new NullPointerException("C_ is marked non-null but is null");
        }
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        if (K == null) {
            throw new NullPointerException("K is marked non-null but is null");
        }
        ECPoint rK = K.multiply(r.negate());
        ECPoint C = C_.add(rK);
        return C;
    }

    public static boolean verify(@NonNull String secret, byte[] k, byte[] C) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        boolean valid = BDHKEUtils.verify(secret, Utils.bigIntFromBytes(k), CURVE.decodePoint(C));
        log.debug("Verification successful? {}", (Object)valid);
        return valid;
    }

    public static boolean verify(@NonNull String secret, @NonNull BigInteger k, @NonNull ECPoint C) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (k == null) {
            throw new NullPointerException("k is marked non-null but is null");
        }
        if (C == null) {
            throw new NullPointerException("C is marked non-null but is null");
        }
        ECPoint Y = BDHKEUtils.hashToCurve(Utils.hexStringToBytes(secret));
        boolean valid = BDHKEUtils.verify(Y, k, C);
        return valid;
    }

    private static boolean verify(byte[] Y, byte[] k, byte[] C) {
        log.debug("verify(bytes): Y={}, k={}, C={}", Utils.bytesToHexString(Y), Utils.bytesToHexString(k), Utils.bytesToHexString(C));
        return BDHKEUtils.verify(CURVE.decodePoint(Y), Utils.bigIntFromBytes(k), CURVE.decodePoint(C));
    }

    private static boolean verify(ECPoint Y, BigInteger k, ECPoint C) {
        log.debug("verify(points): Y={}, k={}, C={}", BDHKEUtils.pointToHex(Y), Utils.bytesToHexString(Utils.bytesFromBigInteger(k)), BDHKEUtils.pointToHex(C));
        ECPoint result = Y.multiply(k);
        return C.equals(result);
    }

    public static String pointToHex(@NonNull ECPoint point) {
        if (point == null) {
            throw new NullPointerException("point is marked non-null but is null");
        }
        byte[] pointBytes = point.getEncoded(true);
        return Hex.toHexString(pointBytes);
    }

    private static byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }
}

