/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.crypto.util;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import lombok.NonNull;
import xyz.tcheeric.cashu.crypto.util.Pair;
import xyz.tcheeric.cashu.crypto.util.Utils;

public class Point {
    private static final BigInteger p = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", 16);
    private static final BigInteger n = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
    public static final Point G = new Point(new BigInteger("79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", 16), new BigInteger("483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", 16));
    private static final BigInteger BI_TWO = BigInteger.valueOf(2L);
    private final Pair<BigInteger, BigInteger> pair;

    public Point(BigInteger x, BigInteger y) {
        this.pair = Pair.of(x, y);
    }

    public Point(byte[] b0, byte[] b1) {
        this.pair = Pair.of(new BigInteger(1, b0), new BigInteger(1, b1));
    }

    public Point(String hex) {
        byte[] x = Utils.hexStringToBytes(hex.substring(0, 64));
        byte[] y = Utils.hexStringToBytes(hex.substring(64));
        this.pair = Pair.of(new BigInteger(1, x), new BigInteger(1, y));
    }

    public static BigInteger getp() {
        return p;
    }

    public static BigInteger getn() {
        return n;
    }

    public static Point getG() {
        return G;
    }

    public BigInteger getX() {
        return this.pair.getLeft();
    }

    public BigInteger getY() {
        return this.pair.getRight();
    }

    public static BigInteger getX(Point P) {
        assert (!P.isInfinite());
        return P.getX();
    }

    public static BigInteger getY(Point P) {
        assert (!P.isInfinite());
        return P.getY();
    }

    public Pair<BigInteger, BigInteger> getPair() {
        return this.pair;
    }

    public boolean isInfinite() {
        return this.pair == null || this.pair.getLeft() == null || this.pair.getRight() == null;
    }

    public static boolean isInfinite(Point P) {
        return P.isInfinite();
    }

    public Point add(@NonNull Point P) {
        if (P == null) {
            throw new NullPointerException("P is marked non-null but is null");
        }
        return Point.add(this, P);
    }

    public static Point add(Point P1, Point P2) {
        BigInteger lam;
        if (P1 != null && P2 != null && P1.isInfinite() && P2.isInfinite()) {
            return Point.infinityPoint();
        }
        if (P1 == null || P1.isInfinite()) {
            return P2;
        }
        if (P2 == null || P2.isInfinite()) {
            return P1;
        }
        if (P1.getX().equals(P2.getX()) && !P1.getY().equals(P2.getY())) {
            return Point.infinityPoint();
        }
        if (P1.equals(P2)) {
            base = P2.getY().multiply(BI_TWO);
            lam = BigInteger.valueOf(3L).multiply(P1.getX()).multiply(P1.getX()).multiply(base.modPow(p.subtract(BI_TWO), p)).mod(p);
        } else {
            base = P2.getX().subtract(P1.getX());
            lam = P2.getY().subtract(P1.getY()).multiply(base.modPow(p.subtract(BI_TWO), p)).mod(p);
        }
        BigInteger x3 = lam.multiply(lam).subtract(P1.getX()).subtract(P2.getX()).mod(p);
        return new Point(x3, lam.multiply(P1.getX().subtract(x3)).subtract(P1.getY()).mod(p));
    }

    public static Point mul(Point P, BigInteger n) {
        Point R = null;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (n.shiftRight(i2).and(BigInteger.ONE).compareTo(BigInteger.ZERO) > 0) {
                R = Point.add(R, P);
            }
            P = Point.add(P, P);
        }
        return R;
    }

    public boolean hasEvenY() {
        return Point.hasEvenY(this);
    }

    public static boolean hasEvenY(Point P) {
        return P.getY().mod(BI_TWO).compareTo(BigInteger.ZERO) == 0;
    }

    public static boolean isSquare(BigInteger x) {
        return x.modPow(p.subtract(BigInteger.ONE).mod(BI_TWO), p).longValue() == 1L;
    }

    public boolean hasSquareY() {
        return Point.hasSquareY(this);
    }

    public static boolean hasSquareY(Point P) {
        assert (!Point.isInfinite(P));
        return Point.isSquare(P.getY());
    }

    public static byte[] taggedHash(String tag, byte[] msg) throws NoSuchAlgorithmException {
        byte[] tagHash = Utils.sha256(tag.getBytes());
        int len = tagHash.length * 2 + msg.length;
        byte[] buf = new byte[len];
        System.arraycopy(tagHash, 0, buf, 0, tagHash.length);
        System.arraycopy(tagHash, 0, buf, tagHash.length, tagHash.length);
        System.arraycopy(msg, 0, buf, tagHash.length * 2, msg.length);
        return Utils.sha256(buf);
    }

    public byte[] toBytes() {
        return Point.bytesFromPoint(this);
    }

    public static byte[] bytesFromPoint(Point P) {
        return Utils.bytesFromBigInteger(P.getX());
    }

    public static Point liftX(byte[] b) {
        BigInteger x = Utils.bigIntFromBytes(b);
        if (x.compareTo(p) >= 0) {
            return null;
        }
        BigInteger y_sq = x.modPow(BigInteger.valueOf(3L), p).add(BigInteger.valueOf(7L)).mod(p);
        BigInteger y = y_sq.modPow(p.add(BigInteger.ONE).divide(BigInteger.valueOf(4L)), p);
        if (y.modPow(BI_TWO, p).compareTo(y_sq) != 0) {
            return null;
        }
        return new Point(x, y.and(BigInteger.ONE).compareTo(BigInteger.ZERO) == 0 ? y : p.subtract(y));
    }

    public static Point infinityPoint() {
        return new Point(null, (BigInteger)null);
    }

    public boolean equals(Point P) {
        return this.getPair().equals(P.getPair());
    }
}

