/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.crypto.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import lombok.NonNull;

public class Utils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toLowerCase().toCharArray();

    public static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToBytes(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have an even length");
        }
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            int digit1 = Character.digit(s.charAt(i2), 16);
            int digit2 = Character.digit(s.charAt(i2 + 1), 16);
            if (digit1 == -1 || digit2 == -1) {
                throw new IllegalArgumentException("Invalid hexadecimal character found");
            }
            data[i2 / 2] = (byte)((digit1 << 4) + digit2);
        }
        return data;
    }

    public static byte[] bytesFromBigInteger(@NonNull BigInteger n) {
        if (n == null) {
            throw new NullPointerException("n is marked non-null but is null");
        }
        byte[] b = n.toByteArray();
        if (b.length == 32) {
            return b;
        }
        if (b.length > 32) {
            return Arrays.copyOfRange(b, b.length - 32, b.length);
        }
        byte[] buf = new byte[32];
        System.arraycopy(b, 0, buf, buf.length - b.length, b.length);
        return buf;
    }

    public static BigInteger bigIntFromBytes(byte[] b) {
        return new BigInteger(1, b);
    }

    public static byte[] sha256(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(b);
    }

    public static byte[] xor(byte[] b0, byte[] b1) {
        if (b0.length != b1.length) {
            return null;
        }
        byte[] ret = new byte[b0.length];
        int i2 = 0;
        for (byte b : b0) {
            ret[i2] = (byte)(b ^ b1[i2]);
            ++i2;
        }
        return ret;
    }
}

