/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.app;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.app.VoucherService;
import xyz.tcheeric.cashu.voucher.app.dto.IssueVoucherRequest;
import xyz.tcheeric.cashu.voucher.app.dto.IssueVoucherResponse;

public class VoucherIssuanceService {
    private static final Logger log = LoggerFactory.getLogger(VoucherIssuanceService.class);
    private final VoucherService voucherService;
    private final long maxVoucherAmount;
    private final int maxExpiryDays;

    public VoucherIssuanceService(@NonNull VoucherService voucherService) {
        this(voucherService, Long.MAX_VALUE, 3650);
        if (voucherService == null) {
            throw new NullPointerException("voucherService is marked non-null but is null");
        }
    }

    public VoucherIssuanceService(@NonNull VoucherService voucherService, long maxVoucherAmount, int maxExpiryDays) {
        if (voucherService == null) {
            throw new NullPointerException("voucherService is marked non-null but is null");
        }
        if (maxVoucherAmount <= 0L) {
            throw new IllegalArgumentException("Max voucher amount must be positive");
        }
        if (maxExpiryDays <= 0) {
            throw new IllegalArgumentException("Max expiry days must be positive");
        }
        this.voucherService = voucherService;
        this.maxVoucherAmount = maxVoucherAmount;
        this.maxExpiryDays = maxExpiryDays;
        log.info("VoucherIssuanceService initialized: maxAmount={}, maxExpiryDays={}", (Object)maxVoucherAmount, (Object)maxExpiryDays);
    }

    public IssueVoucherResponse issueVoucher(@NonNull IssueVoucherRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        log.info("Processing voucher issuance request: issuerId={}, amount={}", (Object)request.getIssuerId(), (Object)request.getAmount());
        this.validateIssuancePolicy(request);
        try {
            IssueVoucherResponse response = this.voucherService.issue(request);
            log.info("Voucher issued successfully: voucherId={}, amount={}", (Object)response.getVoucherId(), (Object)response.getAmount());
            return response;
        }
        catch (Exception e) {
            log.error("Failed to issue voucher: issuerId={}, amount={}", request.getIssuerId(), request.getAmount(), e);
            throw e;
        }
    }

    private void validateIssuancePolicy(IssueVoucherRequest request) {
        if (request.getAmount() > this.maxVoucherAmount) {
            String msg = String.format("Voucher amount %d exceeds maximum allowed %d", request.getAmount(), this.maxVoucherAmount);
            log.warn("Policy violation: {}", (Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (request.getExpiresInDays() != null && request.getExpiresInDays() > this.maxExpiryDays) {
            String msg = String.format("Voucher expiry %d days exceeds maximum allowed %d days", request.getExpiresInDays(), this.maxExpiryDays);
            log.warn("Policy violation: {}", (Object)msg);
            throw new IllegalArgumentException(msg);
        }
        log.debug("Issuance policy validation passed");
    }

    public long getMaxVoucherAmount() {
        return this.maxVoucherAmount;
    }

    public int getMaxExpiryDays() {
        return this.maxExpiryDays;
    }
}

