/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.app.dto;

import java.time.Instant;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherStatus;

public class StoredVoucher {
    private SignedVoucher voucher;
    private Long addedAt;
    private Long lastBackupAt;
    private VoucherStatus cachedStatus;
    private Long statusUpdatedAt;
    private String userLabel;

    public static StoredVoucher from(SignedVoucher voucher) {
        return StoredVoucher.builder().voucher(voucher).addedAt(Instant.now().getEpochSecond()).build();
    }

    public static StoredVoucher from(SignedVoucher voucher, String label) {
        return StoredVoucher.builder().voucher(voucher).addedAt(Instant.now().getEpochSecond()).userLabel(label).build();
    }

    public void markBackedUp() {
        this.lastBackupAt = Instant.now().getEpochSecond();
    }

    public void updateStatus(VoucherStatus status) {
        this.cachedStatus = status;
        this.statusUpdatedAt = Instant.now().getEpochSecond();
    }

    public boolean needsBackup() {
        if (this.lastBackupAt == null) {
            return true;
        }
        return this.addedAt != null && this.addedAt > this.lastBackupAt;
    }

    public boolean isStatusStale(long thresholdSeconds) {
        if (this.statusUpdatedAt == null) {
            return true;
        }
        long age = Instant.now().getEpochSecond() - this.statusUpdatedAt;
        return age > thresholdSeconds;
    }

    public String getVoucherId() {
        return this.voucher != null ? this.voucher.getSecret().getVoucherId() : null;
    }

    public Long getAmount() {
        return this.voucher != null ? Long.valueOf(this.voucher.getSecret().getFaceValue()) : null;
    }

    public String getUnit() {
        return this.voucher != null ? this.voucher.getSecret().getUnit() : null;
    }

    public Long getExpiresAt() {
        return this.voucher != null ? this.voucher.getSecret().getExpiresAt() : null;
    }

    public boolean isExpired() {
        return this.voucher != null && this.voucher.isExpired();
    }

    public static StoredVoucherBuilder builder() {
        return new StoredVoucherBuilder();
    }

    public SignedVoucher getVoucher() {
        return this.voucher;
    }

    public Long getAddedAt() {
        return this.addedAt;
    }

    public Long getLastBackupAt() {
        return this.lastBackupAt;
    }

    public VoucherStatus getCachedStatus() {
        return this.cachedStatus;
    }

    public Long getStatusUpdatedAt() {
        return this.statusUpdatedAt;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setVoucher(SignedVoucher voucher) {
        this.voucher = voucher;
    }

    public void setAddedAt(Long addedAt) {
        this.addedAt = addedAt;
    }

    public void setLastBackupAt(Long lastBackupAt) {
        this.lastBackupAt = lastBackupAt;
    }

    public void setCachedStatus(VoucherStatus cachedStatus) {
        this.cachedStatus = cachedStatus;
    }

    public void setStatusUpdatedAt(Long statusUpdatedAt) {
        this.statusUpdatedAt = statusUpdatedAt;
    }

    public void setUserLabel(String userLabel) {
        this.userLabel = userLabel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredVoucher)) {
            return false;
        }
        StoredVoucher other = (StoredVoucher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$addedAt = this.getAddedAt();
        Long other$addedAt = other.getAddedAt();
        if (this$addedAt == null ? other$addedAt != null : !((Object)this$addedAt).equals(other$addedAt)) {
            return false;
        }
        Long this$lastBackupAt = this.getLastBackupAt();
        Long other$lastBackupAt = other.getLastBackupAt();
        if (this$lastBackupAt == null ? other$lastBackupAt != null : !((Object)this$lastBackupAt).equals(other$lastBackupAt)) {
            return false;
        }
        Long this$statusUpdatedAt = this.getStatusUpdatedAt();
        Long other$statusUpdatedAt = other.getStatusUpdatedAt();
        if (this$statusUpdatedAt == null ? other$statusUpdatedAt != null : !((Object)this$statusUpdatedAt).equals(other$statusUpdatedAt)) {
            return false;
        }
        SignedVoucher this$voucher = this.getVoucher();
        SignedVoucher other$voucher = other.getVoucher();
        if (this$voucher == null ? other$voucher != null : !((Object)this$voucher).equals(other$voucher)) {
            return false;
        }
        VoucherStatus this$cachedStatus = this.getCachedStatus();
        VoucherStatus other$cachedStatus = other.getCachedStatus();
        if (this$cachedStatus == null ? other$cachedStatus != null : !((Object)((Object)this$cachedStatus)).equals((Object)other$cachedStatus)) {
            return false;
        }
        String this$userLabel = this.getUserLabel();
        String other$userLabel = other.getUserLabel();
        return !(this$userLabel == null ? other$userLabel != null : !this$userLabel.equals(other$userLabel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoredVoucher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $addedAt = this.getAddedAt();
        result = result * 59 + ($addedAt == null ? 43 : ((Object)$addedAt).hashCode());
        Long $lastBackupAt = this.getLastBackupAt();
        result = result * 59 + ($lastBackupAt == null ? 43 : ((Object)$lastBackupAt).hashCode());
        Long $statusUpdatedAt = this.getStatusUpdatedAt();
        result = result * 59 + ($statusUpdatedAt == null ? 43 : ((Object)$statusUpdatedAt).hashCode());
        SignedVoucher $voucher = this.getVoucher();
        result = result * 59 + ($voucher == null ? 43 : ((Object)$voucher).hashCode());
        VoucherStatus $cachedStatus = this.getCachedStatus();
        result = result * 59 + ($cachedStatus == null ? 43 : ((Object)((Object)$cachedStatus)).hashCode());
        String $userLabel = this.getUserLabel();
        result = result * 59 + ($userLabel == null ? 43 : $userLabel.hashCode());
        return result;
    }

    public String toString() {
        return "StoredVoucher(voucher=" + String.valueOf(this.getVoucher()) + ", addedAt=" + this.getAddedAt() + ", lastBackupAt=" + this.getLastBackupAt() + ", cachedStatus=" + String.valueOf((Object)this.getCachedStatus()) + ", statusUpdatedAt=" + this.getStatusUpdatedAt() + ", userLabel=" + this.getUserLabel() + ")";
    }

    public StoredVoucher() {
    }

    public StoredVoucher(SignedVoucher voucher, Long addedAt, Long lastBackupAt, VoucherStatus cachedStatus, Long statusUpdatedAt, String userLabel) {
        this.voucher = voucher;
        this.addedAt = addedAt;
        this.lastBackupAt = lastBackupAt;
        this.cachedStatus = cachedStatus;
        this.statusUpdatedAt = statusUpdatedAt;
        this.userLabel = userLabel;
    }

    public static class StoredVoucherBuilder {
        private SignedVoucher voucher;
        private Long addedAt;
        private Long lastBackupAt;
        private VoucherStatus cachedStatus;
        private Long statusUpdatedAt;
        private String userLabel;

        StoredVoucherBuilder() {
        }

        public StoredVoucherBuilder voucher(SignedVoucher voucher) {
            this.voucher = voucher;
            return this;
        }

        public StoredVoucherBuilder addedAt(Long addedAt) {
            this.addedAt = addedAt;
            return this;
        }

        public StoredVoucherBuilder lastBackupAt(Long lastBackupAt) {
            this.lastBackupAt = lastBackupAt;
            return this;
        }

        public StoredVoucherBuilder cachedStatus(VoucherStatus cachedStatus) {
            this.cachedStatus = cachedStatus;
            return this;
        }

        public StoredVoucherBuilder statusUpdatedAt(Long statusUpdatedAt) {
            this.statusUpdatedAt = statusUpdatedAt;
            return this;
        }

        public StoredVoucherBuilder userLabel(String userLabel) {
            this.userLabel = userLabel;
            return this;
        }

        public StoredVoucher build() {
            return new StoredVoucher(this.voucher, this.addedAt, this.lastBackupAt, this.cachedStatus, this.statusUpdatedAt, this.userLabel);
        }

        public String toString() {
            return "StoredVoucher.StoredVoucherBuilder(voucher=" + String.valueOf(this.voucher) + ", addedAt=" + this.addedAt + ", lastBackupAt=" + this.lastBackupAt + ", cachedStatus=" + String.valueOf((Object)this.cachedStatus) + ", statusUpdatedAt=" + this.statusUpdatedAt + ", userLabel=" + this.userLabel + ")";
        }
    }
}

