/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecret;
import xyz.tcheeric.cashu.voucher.domain.VoucherSignatureService;

public final class SignedVoucher {
    @JsonProperty(value="secret")
    private final VoucherSecret secret;
    @JsonProperty(value="issuerSignature")
    private final byte[] issuerSignature;
    @JsonProperty(value="issuerPublicKey")
    private final String issuerPublicKey;

    @JsonCreator
    public SignedVoucher(@JsonProperty(value="secret") @NonNull VoucherSecret secret, @JsonProperty(value="issuerSignature") @NonNull byte[] issuerSignature, @JsonProperty(value="issuerPublicKey") @NonNull String issuerPublicKey) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuerSignature == null) {
            throw new NullPointerException("issuerSignature is marked non-null but is null");
        }
        if (issuerPublicKey == null) {
            throw new NullPointerException("issuerPublicKey is marked non-null but is null");
        }
        if (issuerSignature.length != 64) {
            throw new IllegalArgumentException("Invalid signature length: expected 64 bytes (ED25519), got " + issuerSignature.length);
        }
        if (issuerPublicKey.isBlank()) {
            throw new IllegalArgumentException("Issuer public key cannot be blank");
        }
        this.secret = secret;
        this.issuerSignature = (byte[])issuerSignature.clone();
        this.issuerPublicKey = issuerPublicKey;
    }

    public boolean verify() {
        return VoucherSignatureService.verify(this.secret, this.issuerSignature, this.issuerPublicKey);
    }

    public boolean isExpired() {
        return this.secret.isExpired();
    }

    public boolean isValid() {
        return this.verify() && !this.isExpired();
    }

    public byte[] getIssuerSignature() {
        return (byte[])this.issuerSignature.clone();
    }

    public String toString() {
        return "SignedVoucher{voucherId='" + this.secret.getVoucherId() + "', issuerId='" + this.secret.getIssuerId() + "', faceValue=" + this.secret.getFaceValue() + ", unit='" + this.secret.getUnit() + "', expired=" + this.isExpired() + ", signatureValid=" + this.verify() + ", issuerPublicKey='" + this.issuerPublicKey.substring(0, Math.min(16, this.issuerPublicKey.length())) + "...'}";
    }

    public String toStringWithMetadata() {
        return "SignedVoucher{secret=" + this.secret.toStringWithMetadata() + ", signatureValid=" + this.verify() + ", issuerPublicKey='" + this.issuerPublicKey + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignedVoucher that = (SignedVoucher)o;
        return this.secret.equals(that.secret) && Arrays.equals(this.issuerSignature, that.issuerSignature) && this.issuerPublicKey.equals(that.issuerPublicKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.secret, this.issuerPublicKey);
        result = 31 * result + Arrays.hashCode(this.issuerSignature);
        return result;
    }

    public VoucherSecret getSecret() {
        return this.secret;
    }

    public String getIssuerPublicKey() {
        return this.issuerPublicKey;
    }
}

