/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecretSerializer;
import xyz.tcheeric.cashu.voucher.domain.util.VoucherSerializationUtils;

@JsonSerialize(using=VoucherSecretSerializer.class)
public final class VoucherSecret
extends BaseKey
implements Secret {
    private final String voucherId;
    private final String issuerId;
    private final String unit;
    private final long faceValue;
    private final Long expiresAt;
    private final String memo;

    private VoucherSecret(@NonNull String voucherId, @NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo) {
        super(new byte[0]);
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (faceValue <= 0L) {
            throw new IllegalArgumentException("Face value must be positive, got: " + faceValue);
        }
        if (voucherId.isBlank()) {
            throw new IllegalArgumentException("Voucher ID cannot be blank");
        }
        if (issuerId.isBlank()) {
            throw new IllegalArgumentException("Issuer ID cannot be blank");
        }
        if (unit.isBlank()) {
            throw new IllegalArgumentException("Unit cannot be blank");
        }
        if (expiresAt != null && expiresAt <= 0L) {
            throw new IllegalArgumentException("Expiry timestamp must be positive if provided");
        }
        this.voucherId = voucherId;
        this.issuerId = issuerId;
        this.unit = unit;
        this.faceValue = faceValue;
        this.expiresAt = expiresAt;
        this.memo = memo;
        this.setBytes(this.toCanonicalBytes());
    }

    public static VoucherSecret create(@NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo) {
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return new VoucherSecret(UUID.randomUUID().toString(), issuerId, unit, faceValue, expiresAt, memo);
    }

    public static VoucherSecret create(@NonNull String voucherId, @NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return new VoucherSecret(voucherId, issuerId, unit, faceValue, expiresAt, memo);
    }

    public byte[] toCanonicalBytes() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.expiresAt != null) {
            map.put("expiresAt", this.expiresAt);
        }
        map.put("faceValue", this.faceValue);
        map.put("issuerId", this.issuerId);
        if (this.memo != null && !this.memo.isBlank()) {
            map.put("memo", this.memo);
        }
        map.put("unit", this.unit);
        map.put("voucherId", this.voucherId);
        return VoucherSerializationUtils.toCbor(map);
    }

    public String toHexString() {
        return Hex.toHexString(this.toCanonicalBytes());
    }

    @Override
    public byte[] toBytes() {
        return this.toCanonicalBytes();
    }

    @Override
    public byte[] getData() {
        return this.toCanonicalBytes();
    }

    @Override
    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        throw new UnsupportedOperationException("VoucherSecret is immutable");
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().getEpochSecond() > this.expiresAt;
    }

    public boolean isValid() {
        return !this.isExpired();
    }

    @Override
    public String toString() {
        return this.toHexString();
    }

    public String toStringWithMetadata() {
        StringBuilder sb = new StringBuilder();
        sb.append("VoucherSecret{");
        sb.append("voucherId='").append(this.voucherId).append('\'');
        sb.append(", issuerId='").append(this.issuerId).append('\'');
        sb.append(", unit='").append(this.unit).append('\'');
        sb.append(", faceValue=").append(this.faceValue);
        if (this.expiresAt != null) {
            sb.append(", expiresAt=").append(this.expiresAt);
            sb.append(" (").append(this.isExpired() ? "EXPIRED" : "valid").append(")");
        }
        if (this.memo != null) {
            sb.append(", memo='").append(this.memo).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VoucherSecret that = (VoucherSecret)o;
        return this.faceValue == that.faceValue && this.voucherId.equals(that.voucherId) && this.issuerId.equals(that.issuerId) && this.unit.equals(that.unit) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.memo, that.memo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.voucherId, this.issuerId, this.unit, this.faceValue, this.expiresAt, this.memo);
    }

    public String getVoucherId() {
        return this.voucherId;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getFaceValue() {
        return this.faceValue;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getMemo() {
        return this.memo;
    }
}

