/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import lombok.NonNull;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecret;

public final class VoucherSignatureService {
    private static final Logger logger = LoggerFactory.getLogger(VoucherSignatureService.class);
    private static final int ED25519_PRIVATE_KEY_LENGTH = 32;
    private static final int ED25519_PUBLIC_KEY_LENGTH = 32;
    private static final int ED25519_SIGNATURE_LENGTH = 64;

    private VoucherSignatureService() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static byte[] sign(@NonNull VoucherSecret secret, @NonNull String issuerPrivateKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuerPrivateKeyHex == null) {
            throw new NullPointerException("issuerPrivateKeyHex is marked non-null but is null");
        }
        try {
            byte[] privateKeyBytes = Hex.decode(issuerPrivateKeyHex);
            if (privateKeyBytes.length != 32) {
                throw new IllegalArgumentException("Invalid private key length: expected 32 bytes, got " + privateKeyBytes.length);
            }
            Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(privateKeyBytes, 0);
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(true, privateKey);
            byte[] message = secret.toCanonicalBytes();
            signer.update(message, 0, message.length);
            byte[] signature = signer.generateSignature();
            if (logger.isDebugEnabled()) {
                logger.debug("Signed voucher {} (issuerId={}) with signature length={}", secret.getVoucherId(), secret.getIssuerId(), signature.length);
            }
            return signature;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to sign voucher: " + e.getMessage(), e);
        }
    }

    public static boolean verify(@NonNull VoucherSecret secret, @NonNull byte[] signature, @NonNull String issuerPublicKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        if (issuerPublicKeyHex == null) {
            throw new NullPointerException("issuerPublicKeyHex is marked non-null but is null");
        }
        try {
            if (signature.length != 64) {
                logger.warn("Invalid signature length for voucher {}: expected {} bytes, got {}", secret.getVoucherId(), 64, signature.length);
                return false;
            }
            byte[] publicKeyBytes = Hex.decode(issuerPublicKeyHex);
            if (publicKeyBytes.length != 32) {
                logger.warn("Invalid public key length: expected {} bytes, got {}", (Object)32, (Object)publicKeyBytes.length);
                return false;
            }
            Ed25519PublicKeyParameters publicKey = new Ed25519PublicKeyParameters(publicKeyBytes, 0);
            Ed25519Signer verifier = new Ed25519Signer();
            verifier.init(false, publicKey);
            byte[] message = secret.toCanonicalBytes();
            verifier.update(message, 0, message.length);
            boolean valid = verifier.verifySignature(signature);
            if (logger.isDebugEnabled()) {
                logger.debug("Verified voucher {} (issuerId={}): {}", secret.getVoucherId(), secret.getIssuerId(), valid ? "VALID" : "INVALID");
            }
            return valid;
        }
        catch (Exception e) {
            logger.warn("Signature verification failed for voucher {}: {}", (Object)secret.getVoucherId(), (Object)e.getMessage());
            return false;
        }
    }

    public static SignedVoucher createSigned(@NonNull VoucherSecret secret, @NonNull String issuerPrivateKeyHex, @NonNull String issuerPublicKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuerPrivateKeyHex == null) {
            throw new NullPointerException("issuerPrivateKeyHex is marked non-null but is null");
        }
        if (issuerPublicKeyHex == null) {
            throw new NullPointerException("issuerPublicKeyHex is marked non-null but is null");
        }
        byte[] signature = VoucherSignatureService.sign(secret, issuerPrivateKeyHex);
        return new SignedVoucher(secret, signature, issuerPublicKeyHex);
    }

    private static void validateKeyLength(String keyHex, int expectedBytes, String keyType) {
        byte[] keyBytes = Hex.decode(keyHex);
        if (keyBytes.length != expectedBytes) {
            throw new IllegalArgumentException("Invalid " + keyType + " length: expected " + expectedBytes + " bytes, got " + keyBytes.length);
        }
    }
}

