/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;

public final class VoucherValidator {
    private VoucherValidator() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static ValidationResult validate(@NonNull SignedVoucher voucher) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (!voucher.verify()) {
            errors.add("Invalid issuer signature");
        }
        if (voucher.isExpired()) {
            errors.add("Voucher has expired");
        }
        if (voucher.getSecret().getFaceValue() <= 0L) {
            errors.add("Invalid face value: must be positive");
        }
        if (voucher.getIssuerPublicKey() == null || voucher.getIssuerPublicKey().isBlank()) {
            errors.add("Issuer public key is missing or blank");
        }
        if (voucher.getSecret().getVoucherId() == null || voucher.getSecret().getVoucherId().isBlank()) {
            errors.add("Voucher ID is missing or blank");
        }
        if (voucher.getSecret().getIssuerId() == null || voucher.getSecret().getIssuerId().isBlank()) {
            errors.add("Issuer ID is missing or blank");
        }
        if (voucher.getSecret().getUnit() == null || voucher.getSecret().getUnit().isBlank()) {
            errors.add("Unit is missing or blank");
        }
        if (errors.isEmpty()) {
            return ValidationResult.success();
        }
        return ValidationResult.failure(errors);
    }

    public static ValidationResult validateWithIssuer(@NonNull SignedVoucher voucher, @NonNull String expectedIssuerId) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        if (expectedIssuerId == null) {
            throw new NullPointerException("expectedIssuerId is marked non-null but is null");
        }
        ValidationResult standardResult = VoucherValidator.validate(voucher);
        if (!standardResult.isValid()) {
            return standardResult;
        }
        if (!voucher.getSecret().getIssuerId().equals(expectedIssuerId)) {
            return ValidationResult.failure("Voucher was issued by '" + voucher.getSecret().getIssuerId() + "' but expected issuer is '" + expectedIssuerId + "'");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateSignatureOnly(@NonNull SignedVoucher voucher) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        if (voucher.verify()) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Invalid issuer signature");
    }

    public static ValidationResult validateExpiryOnly(@NonNull SignedVoucher voucher) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        if (voucher.isExpired()) {
            return ValidationResult.failure("Voucher has expired");
        }
        return ValidationResult.success();
    }

    public static boolean isValid(@NonNull SignedVoucher voucher) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        return VoucherValidator.validate(voucher).isValid();
    }

    public static class ValidationResult {
        private final boolean valid;
        private final List<String> errors;

        public static ValidationResult success() {
            return new ValidationResult(true, Collections.emptyList());
        }

        public static ValidationResult failure(@NonNull String error) {
            if (error == null) {
                throw new NullPointerException("error is marked non-null but is null");
            }
            ArrayList<String> errors = new ArrayList<String>();
            errors.add(error);
            return new ValidationResult(false, errors);
        }

        public static ValidationResult failure(@NonNull List<String> errors) {
            if (errors == null) {
                throw new NullPointerException("errors is marked non-null but is null");
            }
            if (errors.isEmpty()) {
                throw new IllegalArgumentException("Errors list cannot be empty for failure result");
            }
            return new ValidationResult(false, new ArrayList<String>(errors));
        }

        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public String getErrorMessage() {
            return String.join((CharSequence)"; ", this.errors);
        }

        public String toString() {
            if (this.valid) {
                return "ValidationResult{valid=true}";
            }
            return "ValidationResult{valid=false, errors=" + String.valueOf(this.errors) + "}";
        }

        public boolean isValid() {
            return this.valid;
        }

        public ValidationResult(boolean valid, List<String> errors) {
            this.valid = valid;
            this.errors = errors;
        }
    }
}

