/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import nostr.event.impl.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.app.ports.VoucherBackupPort;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.nostr.NostrClientAdapter;
import xyz.tcheeric.cashu.voucher.nostr.VoucherNostrException;
import xyz.tcheeric.cashu.voucher.nostr.events.VoucherBackupPayload;

public class NostrVoucherBackupRepository
implements VoucherBackupPort {
    private static final Logger log = LoggerFactory.getLogger(NostrVoucherBackupRepository.class);
    private final NostrClientAdapter nostrClient;
    private final long publishTimeoutMs;
    private final long queryTimeoutMs;

    public NostrVoucherBackupRepository(@NonNull NostrClientAdapter nostrClient) {
        this(nostrClient, 5000L, 5000L);
        if (nostrClient == null) {
            throw new NullPointerException("nostrClient is marked non-null but is null");
        }
    }

    public NostrVoucherBackupRepository(@NonNull NostrClientAdapter nostrClient, long publishTimeoutMs, long queryTimeoutMs) {
        if (nostrClient == null) {
            throw new NullPointerException("nostrClient is marked non-null but is null");
        }
        if (publishTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Publish timeout must be positive");
        }
        if (queryTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Query timeout must be positive");
        }
        this.nostrClient = nostrClient;
        this.publishTimeoutMs = publishTimeoutMs;
        this.queryTimeoutMs = queryTimeoutMs;
        log.info("NostrVoucherBackupRepository initialized: publishTimeout={}ms, queryTimeout={}ms", (Object)publishTimeoutMs, (Object)queryTimeoutMs);
    }

    @Override
    public void backup(@NonNull List<SignedVoucher> vouchers, @NonNull String userPrivateKey) {
        if (vouchers == null) {
            throw new NullPointerException("vouchers is marked non-null but is null");
        }
        if (userPrivateKey == null) {
            throw new NullPointerException("userPrivateKey is marked non-null but is null");
        }
        if (userPrivateKey.isBlank()) {
            throw new IllegalArgumentException("User private key cannot be blank");
        }
        log.info("Backing up {} voucher(s) to Nostr", (Object)vouchers.size());
        try {
            String userPublicKey = this.derivePublicKey(userPrivateKey);
            GenericEvent backupEvent = VoucherBackupPayload.createBackupEvent(vouchers, userPrivateKey, userPublicKey);
            boolean success = this.nostrClient.publishEvent(backupEvent, this.publishTimeoutMs);
            if (!success) {
                throw new VoucherNostrException("Failed to publish backup to any relay: " + vouchers.size() + " vouchers");
            }
            log.info("Successfully backed up {} voucher(s) to Nostr: eventId={}", (Object)vouchers.size(), (Object)backupEvent.getId());
        }
        catch (VoucherNostrException e) {
            log.error("Failed to backup vouchers: count={}", (Object)vouchers.size(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error backing up vouchers: count={}", (Object)vouchers.size(), (Object)e);
            throw new VoucherNostrException("Failed to backup vouchers", e);
        }
    }

    @Override
    public List<SignedVoucher> restore(@NonNull String userPrivateKey) {
        if (userPrivateKey == null) {
            throw new NullPointerException("userPrivateKey is marked non-null but is null");
        }
        if (userPrivateKey.isBlank()) {
            throw new IllegalArgumentException("User private key cannot be blank");
        }
        log.info("Restoring vouchers from Nostr backups");
        try {
            String userPublicKey = this.derivePublicKey(userPrivateKey);
            String subscriptionId = "voucher_backup_" + userPublicKey.substring(0, 8);
            List<GenericEvent> backupEvents = this.nostrClient.queryEvents(subscriptionId, this.queryTimeoutMs);
            log.debug("Found {} backup event(s) from relays", (Object)backupEvents.size());
            if (backupEvents.isEmpty()) {
                log.info("No backup events found");
                return Collections.emptyList();
            }
            HashMap<String, VoucherWithTimestamp> voucherMap = new HashMap<String, VoucherWithTimestamp>();
            for (GenericEvent event : backupEvents) {
                if (!VoucherBackupPayload.isValidBackupEvent(event)) {
                    log.warn("Skipping invalid backup event: eventId={}", (Object)event.getId());
                    continue;
                }
                try {
                    List<SignedVoucher> vouchers = VoucherBackupPayload.extractVouchers(event, userPrivateKey, userPublicKey);
                    long eventTimestamp = event.getCreatedAt();
                    for (SignedVoucher voucher : vouchers) {
                        String voucherId = voucher.getSecret().getVoucherId();
                        VoucherWithTimestamp existing = (VoucherWithTimestamp)voucherMap.get(voucherId);
                        if (existing == null || eventTimestamp > existing.timestamp) {
                            voucherMap.put(voucherId, new VoucherWithTimestamp(voucher, eventTimestamp));
                            log.debug("Added/updated voucher: voucherId={}, timestamp={}", (Object)voucherId, (Object)eventTimestamp);
                            continue;
                        }
                        log.debug("Skipped older voucher: voucherId={}, timestamp={}", (Object)voucherId, (Object)eventTimestamp);
                    }
                }
                catch (VoucherNostrException e) {
                    log.error("Failed to decrypt backup event: eventId={}", (Object)event.getId(), (Object)e);
                }
            }
            List<SignedVoucher> restoredVouchers = voucherMap.values().stream().map(vwt -> vwt.voucher).collect(Collectors.toList());
            log.info("Restored {} unique voucher(s) from {} backup event(s)", (Object)restoredVouchers.size(), (Object)backupEvents.size());
            return restoredVouchers;
        }
        catch (VoucherNostrException e) {
            log.error("Failed to restore vouchers", e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error restoring vouchers", e);
            throw new VoucherNostrException("Failed to restore vouchers", e);
        }
    }

    @Override
    public boolean hasBackups(@NonNull String userPrivateKey) {
        if (userPrivateKey == null) {
            throw new NullPointerException("userPrivateKey is marked non-null but is null");
        }
        if (userPrivateKey.isBlank()) {
            throw new IllegalArgumentException("User private key cannot be blank");
        }
        log.debug("Checking for existing backups");
        try {
            String userPublicKey = this.derivePublicKey(userPrivateKey);
            String subscriptionId = "voucher_backup_check_" + userPublicKey.substring(0, 8);
            List<GenericEvent> backupEvents = this.nostrClient.queryEvents(subscriptionId, this.queryTimeoutMs);
            boolean hasBackups = !backupEvents.isEmpty();
            log.debug("Has backups: {}", (Object)hasBackups);
            return hasBackups;
        }
        catch (Exception e) {
            log.error("Error checking for backups", e);
            throw new VoucherNostrException("Failed to check for backups", e);
        }
    }

    private String derivePublicKey(String privateKey) {
        log.debug("Deriving public key from private key (placeholder)");
        throw new VoucherNostrException("Public key derivation not yet implemented. Please provide both private and public keys explicitly.");
    }

    public NostrClientAdapter getNostrClient() {
        return this.nostrClient;
    }

    private static class VoucherWithTimestamp {
        final SignedVoucher voucher;
        final long timestamp;

        VoucherWithTimestamp(SignedVoucher voucher, long timestamp) {
            this.voucher = voucher;
            this.timestamp = timestamp;
        }
    }
}

