/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr;

import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.event.impl.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.app.ports.VoucherLedgerPort;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherStatus;
import xyz.tcheeric.cashu.voucher.nostr.NostrClientAdapter;
import xyz.tcheeric.cashu.voucher.nostr.VoucherNostrException;
import xyz.tcheeric.cashu.voucher.nostr.events.VoucherLedgerEvent;

public class NostrVoucherLedgerRepository
implements VoucherLedgerPort {
    private static final Logger log = LoggerFactory.getLogger(NostrVoucherLedgerRepository.class);
    private final NostrClientAdapter nostrClient;
    private final PublicKey issuerPublicKey;
    private final long publishTimeoutMs;
    private final long queryTimeoutMs;

    public NostrVoucherLedgerRepository(@NonNull NostrClientAdapter nostrClient, @NonNull PublicKey issuerPublicKey) {
        this(nostrClient, issuerPublicKey, 5000L, 5000L);
        if (nostrClient == null) {
            throw new NullPointerException("nostrClient is marked non-null but is null");
        }
        if (issuerPublicKey == null) {
            throw new NullPointerException("issuerPublicKey is marked non-null but is null");
        }
    }

    public NostrVoucherLedgerRepository(@NonNull NostrClientAdapter nostrClient, @NonNull PublicKey issuerPublicKey, long publishTimeoutMs, long queryTimeoutMs) {
        if (nostrClient == null) {
            throw new NullPointerException("nostrClient is marked non-null but is null");
        }
        if (issuerPublicKey == null) {
            throw new NullPointerException("issuerPublicKey is marked non-null but is null");
        }
        if (publishTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Publish timeout must be positive");
        }
        if (queryTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Query timeout must be positive");
        }
        this.nostrClient = nostrClient;
        this.issuerPublicKey = issuerPublicKey;
        this.publishTimeoutMs = publishTimeoutMs;
        this.queryTimeoutMs = queryTimeoutMs;
        log.info("NostrVoucherLedgerRepository initialized: issuer={}, publishTimeout={}ms, queryTimeout={}ms", issuerPublicKey.toBech32String(), publishTimeoutMs, queryTimeoutMs);
    }

    @Override
    public void publish(@NonNull SignedVoucher voucher, @NonNull VoucherStatus status) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        String voucherId = voucher.getSecret().getVoucherId();
        log.info("Publishing voucher to ledger: voucherId={}, status={}", (Object)voucherId, (Object)status);
        try {
            VoucherLedgerEvent event = VoucherLedgerEvent.fromVoucher(voucher, status);
            event.setPubKey(this.issuerPublicKey);
            boolean success = this.nostrClient.publishEvent(event, this.publishTimeoutMs);
            if (!success) {
                throw new VoucherNostrException("Failed to publish voucher to any relay: voucherId=" + voucherId);
            }
            log.info("Successfully published voucher: voucherId={}, eventId={}", (Object)voucherId, (Object)event.getId());
        }
        catch (VoucherNostrException e) {
            log.error("Failed to publish voucher: voucherId={}", (Object)voucherId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error publishing voucher: voucherId={}", (Object)voucherId, (Object)e);
            throw new VoucherNostrException("Failed to publish voucher", e);
        }
    }

    @Override
    public Optional<VoucherStatus> queryStatus(@NonNull String voucherId) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (voucherId.isBlank()) {
            throw new IllegalArgumentException("Voucher ID cannot be blank");
        }
        log.debug("Querying voucher status: voucherId={}", (Object)voucherId);
        try {
            String subscriptionId = "voucher_status_" + voucherId;
            List<GenericEvent> events = this.nostrClient.queryEvents(subscriptionId, this.queryTimeoutMs);
            if (events.isEmpty()) {
                log.debug("Voucher not found in ledger: voucherId={}", (Object)voucherId);
                return Optional.empty();
            }
            GenericEvent mostRecent = (GenericEvent)events.stream().max((e1, e2) -> Long.compare(e1.getCreatedAt(), e2.getCreatedAt())).orElseThrow();
            if (mostRecent instanceof VoucherLedgerEvent) {
                VoucherLedgerEvent ledgerEvent = (VoucherLedgerEvent)mostRecent;
                VoucherStatus status = ledgerEvent.getStatus();
                log.debug("Found voucher status: voucherId={}, status={}", (Object)voucherId, (Object)status);
                return Optional.of(status);
            }
            log.warn("Received non-VoucherLedgerEvent, attempting to parse: voucherId={}", (Object)voucherId);
            return Optional.empty();
        }
        catch (VoucherNostrException e) {
            log.error("Failed to query voucher status: voucherId={}", (Object)voucherId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error querying voucher status: voucherId={}", (Object)voucherId, (Object)e);
            throw new VoucherNostrException("Failed to query voucher status", e);
        }
    }

    @Override
    public void updateStatus(@NonNull String voucherId, @NonNull VoucherStatus newStatus) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (newStatus == null) {
            throw new NullPointerException("newStatus is marked non-null but is null");
        }
        if (voucherId.isBlank()) {
            throw new IllegalArgumentException("Voucher ID cannot be blank");
        }
        log.info("Updating voucher status: voucherId={}, newStatus={}", (Object)voucherId, (Object)newStatus);
        try {
            Optional<SignedVoucher> voucherOpt = this.queryVoucher(voucherId);
            if (voucherOpt.isEmpty()) {
                throw new VoucherNostrException("Voucher not found in ledger: " + voucherId);
            }
            SignedVoucher voucher = voucherOpt.get();
            this.publish(voucher, newStatus);
            log.info("Successfully updated voucher status: voucherId={}, newStatus={}", (Object)voucherId, (Object)newStatus);
        }
        catch (VoucherNostrException e) {
            log.error("Failed to update voucher status: voucherId={}", (Object)voucherId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error updating voucher status: voucherId={}", (Object)voucherId, (Object)e);
            throw new VoucherNostrException("Failed to update voucher status", e);
        }
    }

    @Override
    public Optional<SignedVoucher> queryVoucher(@NonNull String voucherId) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (voucherId.isBlank()) {
            throw new IllegalArgumentException("Voucher ID cannot be blank");
        }
        log.debug("Querying full voucher: voucherId={}", (Object)voucherId);
        try {
            String subscriptionId = "voucher_full_" + voucherId;
            List<GenericEvent> events = this.nostrClient.queryEvents(subscriptionId, this.queryTimeoutMs);
            if (events.isEmpty()) {
                log.debug("Voucher not found in ledger: voucherId={}", (Object)voucherId);
                return Optional.empty();
            }
            GenericEvent mostRecent = (GenericEvent)events.stream().max((e1, e2) -> Long.compare(e1.getCreatedAt(), e2.getCreatedAt())).orElseThrow();
            if (mostRecent instanceof VoucherLedgerEvent) {
                VoucherLedgerEvent ledgerEvent = (VoucherLedgerEvent)mostRecent;
                SignedVoucher voucher = ledgerEvent.toVoucher();
                log.debug("Found voucher in ledger: voucherId={}", (Object)voucherId);
                return Optional.of(voucher);
            }
            log.warn("Received non-VoucherLedgerEvent, attempting to parse: voucherId={}", (Object)voucherId);
            return Optional.empty();
        }
        catch (VoucherNostrException e) {
            log.error("Failed to query voucher: voucherId={}", (Object)voucherId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error querying voucher: voucherId={}", (Object)voucherId, (Object)e);
            throw new VoucherNostrException("Failed to query voucher", e);
        }
    }

    public PublicKey getIssuerPublicKey() {
        return this.issuerPublicKey;
    }

    public NostrClientAdapter getNostrClient() {
        return this.nostrClient;
    }
}

