/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.client;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractRequestBase<T, U> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestBase.class);
    private final RestTemplate restTemplate;
    private final String baseUrl;
    private final String path;
    private final String httpMethod;
    private final U requestObject;
    private final Class<T> responseType;
    private String serverAddress;
    private String serverPort;
    private String version;
    protected static final String HTTP_METHOD_GET = "GET";
    protected static final String HTTP_METHOD_POST = "POST";

    public AbstractRequestBase(@NonNull String baseUrl, @NonNull String path, Class<T> responseType) {
        this(baseUrl, path, HTTP_METHOD_GET, null, responseType);
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public AbstractRequestBase(@NonNull String baseUrl, @NonNull String path, @NonNull String httpMethod, U requestObject, Class<T> responseType) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        this.baseUrl = baseUrl;
        this.path = path;
        this.httpMethod = httpMethod;
        this.requestObject = requestObject;
        this.responseType = responseType;
    }

    public T execute() {
        return switch (this.httpMethod) {
            case HTTP_METHOD_GET -> {
                log.debug("request_base dispatching_request method={} target={} reason=execute_invoked", (Object)HTTP_METHOD_GET, (Object)(this.baseUrl + this.path));
                T response = this.restTemplate.getForObject(this.baseUrl + this.path, this.responseType, new Object[0]);
                log.info("request_base request_completed method={} target={} result=success", (Object)HTTP_METHOD_GET, (Object)(this.baseUrl + this.path));
                yield response;
            }
            case HTTP_METHOD_POST -> {
                log.debug("request_base dispatching_request method={} target={} reason=execute_invoked", (Object)HTTP_METHOD_POST, (Object)(this.baseUrl + this.path));
                T response = this.restTemplate.postForObject(this.baseUrl + this.path, this.requestObject, this.responseType, new Object[0]);
                log.info("request_base request_completed method={} target={} result=success", (Object)HTTP_METHOD_POST, (Object)(this.baseUrl + this.path));
                yield response;
            }
            default -> throw new IllegalArgumentException("Unsupported HTTP method: " + this.httpMethod);
        };
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public U getRequestObject() {
        return this.requestObject;
    }

    @Generated
    public Class<T> getResponseType() {
        return this.responseType;
    }

    @Generated
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Generated
    public String getServerPort() {
        return this.serverPort;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

