/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.client.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bitcoinj.crypto.DeterministicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.wallet.client.service.ParallelRecoveryService;
import xyz.tcheeric.cashu.wallet.client.service.RestoreClientFactory;
import xyz.tcheeric.cashu.wallet.client.service.WalletRecoveryServiceImpl;
import xyz.tcheeric.cashu.wallet.proto.builders.RestoreRequestBuilder;
import xyz.tcheeric.cashu.wallet.proto.service.ProofRecoveryService;

@Nut(value=13)
public class ParallelRecoveryServiceImpl
extends WalletRecoveryServiceImpl
implements ParallelRecoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParallelRecoveryServiceImpl.class);

    public ParallelRecoveryServiceImpl(@NonNull String mintUrl) {
        super(mintUrl);
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        log.debug("parallel_recovery service_created mint_url={}", (Object)mintUrl);
    }

    public ParallelRecoveryServiceImpl(@NonNull String mintUrl, @NonNull RestoreRequestBuilder requestBuilder, @NonNull ProofRecoveryService proofRecoveryService) {
        super(mintUrl, requestBuilder, proofRecoveryService);
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (proofRecoveryService == null) {
            throw new NullPointerException("proofRecoveryService is marked non-null but is null");
        }
        log.debug("parallel_recovery service_created mint_url={} custom_dependencies=true", (Object)mintUrl);
    }

    public ParallelRecoveryServiceImpl(@NonNull String mintUrl, @NonNull RestoreRequestBuilder requestBuilder, @NonNull ProofRecoveryService proofRecoveryService, @NonNull RestoreClientFactory restoreClientFactory) {
        super(mintUrl, requestBuilder, proofRecoveryService, restoreClientFactory);
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (proofRecoveryService == null) {
            throw new NullPointerException("proofRecoveryService is marked non-null but is null");
        }
        if (restoreClientFactory == null) {
            throw new NullPointerException("restoreClientFactory is marked non-null but is null");
        }
        log.debug("parallel_recovery service_created mint_url={} custom_factory=true", (Object)mintUrl);
    }

    @Override
    public CompletableFuture<Map<KeysetId, List<Proof<DeterministicSecret>>>> recoverParallel(@NonNull String mnemonic, @NonNull String passphrase, @NonNull List<KeysetId> keysetIds, @NonNull List<KeySet> keySets, @NonNull ExecutorService executor) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        if (passphrase == null) {
            throw new NullPointerException("passphrase is marked non-null but is null");
        }
        if (keysetIds == null) {
            throw new NullPointerException("keysetIds is marked non-null but is null");
        }
        if (keySets == null) {
            throw new NullPointerException("keySets is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (keysetIds.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Keyset IDs list cannot be empty"));
        }
        if (keySets.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("KeySets list cannot be empty"));
        }
        if (!Bip39.isValidMnemonic(mnemonic)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid BIP39 mnemonic phrase"));
        }
        log.info("parallel_recovery service_started keysets_count={} executor={}", (Object)keysetIds.size(), (Object)executor.getClass().getSimpleName());
        CompletableFuture<DeterministicKey> masterKeyFuture = CompletableFuture.supplyAsync(() -> {
            try {
                log.debug("parallel_recovery master_key_derivation_started");
                DeterministicKey key = Bip39.mnemonicToMasterKey(mnemonic, passphrase);
                log.debug("parallel_recovery master_key_derivation_completed");
                return key;
            }
            catch (Exception e) {
                log.error("parallel_recovery master_key_derivation_failed error={}", (Object)e.getMessage(), (Object)e);
                throw new IllegalStateException("Failed to derive master key: " + e.getMessage(), e);
            }
        }, executor);
        return masterKeyFuture.thenCompose(masterKey -> this.recoverParallel((DeterministicKey)masterKey, keysetIds, keySets, executor));
    }

    @Override
    public CompletableFuture<Map<KeysetId, List<Proof<DeterministicSecret>>>> recoverParallel(@NonNull DeterministicKey masterKey, @NonNull List<KeysetId> keysetIds, @NonNull List<KeySet> keySets, @NonNull ExecutorService executor) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetIds == null) {
            throw new NullPointerException("keysetIds is marked non-null but is null");
        }
        if (keySets == null) {
            throw new NullPointerException("keySets is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        log.info("parallel_recovery keyset_recovery_started keysets_count={}", (Object)keysetIds.size());
        Map<String, KeySet> keySetMap = keySets.stream().collect(Collectors.toMap(KeySet::getId, ks -> ks));
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(keysetIds.size());
        for (KeysetId keysetId : keysetIds) {
            KeySet keySet = keySetMap.get(keysetId.toString());
            if (keySet == null) {
                log.warn("parallel_recovery keyset_missing keyset={} action=skip", (Object)keysetId);
                futures.add(CompletableFuture.completedFuture(new KeysetRecoveryResult(keysetId, List.of(), false)));
                continue;
            }
            CompletionStage future = ((CompletableFuture)this.recoverKeysetAsync(masterKey, keysetId, keySet, 0, executor).thenApply(proofs -> {
                log.info("parallel_recovery keyset_completed keyset={} proofs_count={}", (Object)keysetId, (Object)proofs.size());
                return new KeysetRecoveryResult(keysetId, (List<Proof<DeterministicSecret>>)proofs, true);
            })).exceptionally(error -> {
                log.error("parallel_recovery keyset_failed keyset={} error={}", keysetId, error.getMessage(), error);
                return new KeysetRecoveryResult(keysetId, List.of(), false);
            });
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            ConcurrentHashMap<KeysetId, List<Proof<DeterministicSecret>>> results = new ConcurrentHashMap<KeysetId, List<Proof<DeterministicSecret>>>();
            for (CompletableFuture future : futures) {
                try {
                    KeysetRecoveryResult result = (KeysetRecoveryResult)future.join();
                    if (!result.success()) continue;
                    results.put(result.keysetId(), result.proofs());
                }
                catch (Exception e) {
                    log.error("parallel_recovery result_collection_error error={}", (Object)e.getMessage(), (Object)e);
                }
            }
            int totalProofs = results.values().stream().mapToInt(List::size).sum();
            log.info("parallel_recovery service_completed successful_keysets={} total_proofs={}", (Object)results.size(), (Object)totalProofs);
            return results;
        });
    }

    @Override
    public CompletableFuture<List<Proof<DeterministicSecret>>> recoverKeysetAsync(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, @NonNull KeySet keySet, int startCounter, @NonNull ExecutorService executor) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        return this.recoverKeysetAsync(masterKey, keysetId, keySet, startCounter, 100, executor);
    }

    @Override
    public CompletableFuture<List<Proof<DeterministicSecret>>> recoverKeysetAsync(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, @NonNull KeySet keySet, int startCounter, int batchSize, @NonNull ExecutorService executor) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        log.debug("parallel_recovery keyset_async_started keyset={} start_counter={} batch_size={}", keysetId, startCounter, batchSize);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.recoverKeyset(masterKey, keysetId, keySet, startCounter, batchSize);
            }
            catch (Exception e) {
                log.error("parallel_recovery keyset_async_failed keyset={} error={}", keysetId, e.getMessage(), e);
                throw e;
            }
        }, executor);
    }

    @Override
    @Generated
    public String toString() {
        return "ParallelRecoveryServiceImpl(super=" + super.toString() + ")";
    }

    private record KeysetRecoveryResult(KeysetId keysetId, List<Proof<DeterministicSecret>> proofs, boolean success) {
    }
}

