/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.client.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bitcoinj.crypto.DeterministicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestRestore;
import xyz.tcheeric.cashu.wallet.client.service.RestoreClientFactory;
import xyz.tcheeric.cashu.wallet.client.service.WalletRecoveryService;
import xyz.tcheeric.cashu.wallet.proto.builders.RestoreRequestBuilder;
import xyz.tcheeric.cashu.wallet.proto.service.ProofRecoveryService;
import xyz.tcheeric.cashu.wallet.proto.service.ProofRecoveryServiceImpl;
import xyz.tcheeric.cashu.wallet.proto.tasks.DeriveSecretsTask;

@Nut(value=13)
public class WalletRecoveryServiceImpl
implements WalletRecoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WalletRecoveryServiceImpl.class);
    private final String mintUrl;
    private final RestoreRequestBuilder requestBuilder;
    private final ProofRecoveryService proofRecoveryService;
    private final RestoreClientFactory restoreClientFactory;

    public WalletRecoveryServiceImpl(@NonNull String mintUrl) {
        this(mintUrl, new RestoreRequestBuilder(), new ProofRecoveryServiceImpl(), new DefaultRestoreClientFactory());
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
    }

    public WalletRecoveryServiceImpl(@NonNull String mintUrl, @NonNull RestoreRequestBuilder requestBuilder, @NonNull ProofRecoveryService proofRecoveryService) {
        this(mintUrl, requestBuilder, proofRecoveryService, new DefaultRestoreClientFactory());
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (proofRecoveryService == null) {
            throw new NullPointerException("proofRecoveryService is marked non-null but is null");
        }
    }

    public WalletRecoveryServiceImpl(@NonNull String mintUrl, @NonNull RestoreRequestBuilder requestBuilder, @NonNull ProofRecoveryService proofRecoveryService, @NonNull RestoreClientFactory restoreClientFactory) {
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (proofRecoveryService == null) {
            throw new NullPointerException("proofRecoveryService is marked non-null but is null");
        }
        if (restoreClientFactory == null) {
            throw new NullPointerException("restoreClientFactory is marked non-null but is null");
        }
        this.mintUrl = mintUrl;
        this.requestBuilder = requestBuilder;
        this.proofRecoveryService = proofRecoveryService;
        this.restoreClientFactory = restoreClientFactory;
    }

    @Override
    public List<Proof<DeterministicSecret>> recover(@NonNull String mnemonic, @NonNull String passphrase, @NonNull List<KeysetId> keysetIds, @NonNull List<KeySet> keySets) {
        DeterministicKey masterKey;
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        if (passphrase == null) {
            throw new NullPointerException("passphrase is marked non-null but is null");
        }
        if (keysetIds == null) {
            throw new NullPointerException("keysetIds is marked non-null but is null");
        }
        if (keySets == null) {
            throw new NullPointerException("keySets is marked non-null but is null");
        }
        if (keysetIds.isEmpty()) {
            throw new IllegalArgumentException("Keyset IDs list cannot be empty");
        }
        if (keySets.isEmpty()) {
            throw new IllegalArgumentException("KeySets list cannot be empty");
        }
        if (!Bip39.isValidMnemonic(mnemonic)) {
            throw new IllegalArgumentException("Invalid BIP39 mnemonic phrase");
        }
        log.info("wallet_recovery service_started keysets_count={} mint_url={}", (Object)keysetIds.size(), (Object)this.mintUrl);
        try {
            masterKey = Bip39.mnemonicToMasterKey(mnemonic, passphrase);
        }
        catch (Exception e) {
            log.error("wallet_recovery master_key_derivation_failed error={} impact=abort", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to derive master key from mnemonic: " + e.getMessage(), e);
        }
        Map<String, KeySet> keySetMap = keySets.stream().collect(Collectors.toMap(KeySet::getId, ks -> ks));
        ArrayList<Proof<DeterministicSecret>> allProofs = new ArrayList<Proof<DeterministicSecret>>();
        for (KeysetId keysetId : keysetIds) {
            try {
                KeySet keySet = keySetMap.get(keysetId.toString());
                if (keySet == null) {
                    log.warn("wallet_recovery keyset_missing keyset={} action=skip", (Object)keysetId);
                    continue;
                }
                log.info("wallet_recovery keyset_processing_started keyset={}", (Object)keysetId);
                List<Proof<DeterministicSecret>> keysetProofs = this.recoverKeyset(masterKey, keysetId, keySet, 0);
                allProofs.addAll(keysetProofs);
                log.info("wallet_recovery keyset_processing_completed keyset={} recovered_count={}", (Object)keysetId, (Object)keysetProofs.size());
            }
            catch (Exception e) {
                log.error("wallet_recovery keyset_processing_failed keyset={} error={} impact=continuing_other_keysets", keysetId, e.getMessage(), e);
            }
        }
        log.info("wallet_recovery service_completed total_proofs={} requested_keysets={}", (Object)allProofs.size(), (Object)keysetIds.size());
        return allProofs;
    }

    @Override
    public List<Proof<DeterministicSecret>> recoverKeyset(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, @NonNull KeySet keySet, int startCounter) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        return this.recoverKeyset(masterKey, keysetId, keySet, startCounter, 100);
    }

    @Override
    public List<Proof<DeterministicSecret>> recoverKeyset(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, @NonNull KeySet keySet, int startCounter, int batchSize) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be positive, got: " + batchSize);
        }
        if (startCounter < 0) {
            throw new IllegalArgumentException("Start counter must be non-negative, got: " + startCounter);
        }
        log.info("wallet_recovery keyset_recovery_started keyset={} start_counter={} batch_size={}", keysetId, startCounter, batchSize);
        ArrayList<Proof<DeterministicSecret>> allProofs = new ArrayList<Proof<DeterministicSecret>>();
        int counter = startCounter;
        int emptyBatches = 0;
        int batchNumber = 0;
        while (emptyBatches < 3) {
            block10: {
                log.debug("wallet_recovery batch_processing_started keyset={} batch={} counter={} empty_batches={}", keysetId, ++batchNumber, counter, emptyBatches);
                try {
                    DeriveSecretsTask deriveTask = new DeriveSecretsTask(masterKey, keysetId, counter, batchSize);
                    DeriveSecretsTask.DeriveSecretsResult deriveResult = deriveTask.execute();
                    PostRestoreRequest request = this.requestBuilder.buildRequestFromSecrets(deriveResult.getSecrets(), deriveResult.getBlindingFactors(), 1);
                    RequestRestore restoreClient = this.restoreClientFactory.create(this.mintUrl, keySet, request);
                    PostRestoreResponse response = (PostRestoreResponse)restoreClient.execute();
                    if (response == null || response.getBlindSignatures() == null || response.getBlindSignatures().isEmpty()) {
                        log.debug("wallet_recovery batch_empty keyset={} batch={} counter={} empty_batch_count={}", keysetId, batchNumber, counter, ++emptyBatches);
                    } else {
                        emptyBatches = 0;
                        log.info("wallet_recovery signatures_detected keyset={} batch={} signatures={}", keysetId, batchNumber, response.getBlindSignatures().size());
                        List<Proof<DeterministicSecret>> batchProofs = this.proofRecoveryService.unblindAndCreateProofs(response, deriveResult.getSecrets(), deriveResult.getBlindingFactors(), keySet);
                        allProofs.addAll(batchProofs);
                        log.info("wallet_recovery batch_processing_completed keyset={} batch={} proofs_created={} total_accumulated={}", keysetId, batchNumber, batchProofs.size(), allProofs.size());
                    }
                }
                catch (Exception e) {
                    log.error("wallet_recovery batch_processing_failed keyset={} batch={} counter={} error={} impact=increment_empty_batches", keysetId, batchNumber, counter, e.getMessage(), e);
                    if (++emptyBatches < 3) break block10;
                    log.warn("wallet_recovery batch_error_limit_reached keyset={} action=stop_recovery", (Object)keysetId);
                    break;
                }
            }
            counter += batchSize;
        }
        log.info("wallet_recovery keyset_recovery_finished keyset={} total_proofs={} batches_processed={}", keysetId, allProofs.size(), batchNumber);
        return allProofs;
    }

    @Generated
    public String toString() {
        return "WalletRecoveryServiceImpl(requestBuilder=" + String.valueOf(this.requestBuilder) + ", proofRecoveryService=" + String.valueOf(this.proofRecoveryService) + ")";
    }

    private static final class DefaultRestoreClientFactory
    implements RestoreClientFactory {
        private DefaultRestoreClientFactory() {
        }

        @Override
        public RequestRestore create(String mintUrl, KeySet keySet, PostRestoreRequest request) {
            return new RequestRestore(mintUrl, request);
        }
    }
}

