/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.builders;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;

@Nut(value=9)
public class RestoreRequestBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestoreRequestBuilder.class);

    public List<BlindedMessage> createBlindedMessages(@NonNull List<DeterministicSecret> secrets, @NonNull List<byte[]> blindingFactors, int amount) {
        if (secrets == null) {
            throw new NullPointerException("secrets is marked non-null but is null");
        }
        if (blindingFactors == null) {
            throw new NullPointerException("blindingFactors is marked non-null but is null");
        }
        if (secrets.isEmpty()) {
            throw new IllegalArgumentException("Secrets list cannot be empty");
        }
        if (secrets.size() != blindingFactors.size()) {
            throw new IllegalArgumentException(String.format("Secrets and blinding factors count mismatch: secrets=%d, blindingFactors=%d", secrets.size(), blindingFactors.size()));
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive, got: " + amount);
        }
        KeysetId keysetId = secrets.get(0).getKeysetId();
        if (keysetId == null) {
            throw new IllegalArgumentException("First secret has null keyset ID");
        }
        for (int i2 = 1; i2 < secrets.size(); ++i2) {
            KeysetId currentKeysetId = secrets.get(i2).getKeysetId();
            if (currentKeysetId != null && currentKeysetId.equals(keysetId)) continue;
            throw new IllegalArgumentException(String.format("All secrets must have the same keyset ID. Expected=%s, got=%s at index=%d", keysetId, currentKeysetId, i2));
        }
        log.info("restore_request_builder blinding_started keyset={} secret_count={} amount={}", keysetId, secrets.size(), amount);
        ArrayList<BlindedMessage> blindedMessages = new ArrayList<BlindedMessage>(secrets.size());
        for (int i3 = 0; i3 < secrets.size(); ++i3) {
            DeterministicSecret secret = secrets.get(i3);
            byte[] blindingFactor = blindingFactors.get(i3);
            try {
                if (blindingFactor == null || blindingFactor.length != 32) {
                    throw new IllegalArgumentException(String.format("Blinding factor at index %d must be 32 bytes, got: %s", i3, blindingFactor == null ? "null" : Integer.valueOf(blindingFactor.length)));
                }
                byte[] blindedBytes = BDHKEUtils.blindMessage(secret.getData(), blindingFactor);
                BlindedMessage blindedMessage = BlindedMessage.builder().amount(amount).keySetId(keysetId).blindedMessage(PublicKey.fromBytes(blindedBytes, false)).build();
                blindedMessages.add(blindedMessage);
                continue;
            }
            catch (Exception e) {
                log.error("restore_request_builder blinding_failed index={} counter={} error={} impact=abort_batch", i3, secret.getCounter(), e.getMessage(), e);
                throw new IllegalStateException(String.format("Failed to create blinded message at index %d (counter=%d): %s", i3, secret.getCounter(), e.getMessage()), e);
            }
        }
        log.info("restore_request_builder blinding_completed keyset={} created_count={}", (Object)keysetId, (Object)blindedMessages.size());
        return blindedMessages;
    }

    public PostRestoreRequest buildRequest(@NonNull List<BlindedMessage> blindedMessages) {
        if (blindedMessages == null) {
            throw new NullPointerException("blindedMessages is marked non-null but is null");
        }
        if (blindedMessages.isEmpty()) {
            throw new IllegalArgumentException("Blinded messages list cannot be empty");
        }
        log.debug("restore_request_builder request_build_started outputs_count={}", (Object)blindedMessages.size());
        return new PostRestoreRequest(blindedMessages);
    }

    public PostRestoreRequest buildRequestFromSecrets(@NonNull List<DeterministicSecret> secrets, @NonNull List<byte[]> blindingFactors, int amount) {
        if (secrets == null) {
            throw new NullPointerException("secrets is marked non-null but is null");
        }
        if (blindingFactors == null) {
            throw new NullPointerException("blindingFactors is marked non-null but is null");
        }
        List<BlindedMessage> blindedMessages = this.createBlindedMessages(secrets, blindingFactors, amount);
        return this.buildRequest(blindedMessages);
    }

    @Generated
    public RestoreRequestBuilder() {
    }

    @Generated
    public String toString() {
        return "RestoreRequestBuilder()";
    }
}

