/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.nut;

import java.math.BigInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.wallet.proto.tasks.UnblindSignatureTask;

public class NUT04 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NUT04.class);

    public static <T extends Secret> Proof<T> unblindingSignature(@NonNull BlindSignature blindSignature, @NonNull BigInteger r, @NonNull PublicKey K, @NonNull T secret) {
        if (blindSignature == null) {
            throw new NullPointerException("blindSignature is marked non-null but is null");
        }
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        if (K == null) {
            throw new NullPointerException("K is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        log.debug("nut04 unblinding_requested keyset={} amount={}", (Object)blindSignature.getKeySetId(), (Object)blindSignature.getAmount());
        Object proof = new UnblindSignatureTask<T>(blindSignature, r, K, secret).execute();
        log.debug("nut04 unblinding_completed keyset={} amount={}", (Object)blindSignature.getKeySetId(), (Object)blindSignature.getAmount());
        return proof;
    }
}

