/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.wallet.proto.state.DerivationStateManager;

@Nut(value=13)
public class InMemoryDerivationStateManager
implements DerivationStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryDerivationStateManager.class);
    private final ConcurrentHashMap<String, AtomicInteger> counters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<Integer>> mintRecords = new ConcurrentHashMap();

    @Override
    public int getCurrentCounter(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        AtomicInteger counter = this.counters.get(key);
        if (counter == null) {
            log.debug("derivation_state get_counter keyset={} counter=0 reason=new_keyset", (Object)keysetId);
            return 0;
        }
        int value = counter.get();
        log.debug("derivation_state get_counter keyset={} counter={}", (Object)keysetId, (Object)value);
        return value;
    }

    @Override
    public void incrementCounter(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        int newValue = this.counters.computeIfAbsent(key, k -> new AtomicInteger(0)).incrementAndGet();
        log.info("derivation_state increment_counter keyset={} new_counter={}", (Object)keysetId, (Object)newValue);
    }

    @Override
    public void setCounter(@NonNull KeysetId keysetId, int counter) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (counter < 0) {
            throw new IllegalArgumentException("Counter must be non-negative, got: " + counter);
        }
        String key = keysetId.toString();
        int oldValue = this.counters.computeIfAbsent(key, k -> new AtomicInteger(0)).getAndSet(counter);
        if (counter < oldValue) {
            log.warn("derivation_state set_counter keyset={} old_counter={} new_counter={} warning=counter_decreased risk=potential_key_reuse", keysetId, oldValue, counter);
        } else {
            log.info("derivation_state set_counter keyset={} old_counter={} new_counter={}", keysetId, oldValue, counter);
        }
    }

    @Override
    public void recordMint(@NonNull KeysetId keysetId, int counter) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (counter < 0) {
            throw new IllegalArgumentException("Counter must be non-negative, got: " + counter);
        }
        String key = keysetId.toString();
        Set records = this.mintRecords.computeIfAbsent(key, k -> Collections.synchronizedSet(new HashSet()));
        boolean added = records.add(counter);
        if (added) {
            log.info("derivation_state record_mint keyset={} counter={} total_mints={}", keysetId, counter, records.size());
        } else {
            log.debug("derivation_state record_mint keyset={} counter={} status=duplicate", (Object)keysetId, (Object)counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> detectGaps(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        int currentCounter = this.getCurrentCounter(keysetId);
        Set<Integer> records = this.mintRecords.get(key);
        if (records == null || records.isEmpty()) {
            log.debug("derivation_state detect_gaps keyset={} gaps=0 reason=no_mints", (Object)keysetId);
            return List.of();
        }
        ArrayList<Integer> gaps = new ArrayList<Integer>();
        Set<Integer> set = records;
        synchronized (set) {
            for (int i2 = 0; i2 < currentCounter; ++i2) {
                if (records.contains(i2)) continue;
                gaps.add(i2);
            }
        }
        if (!gaps.isEmpty()) {
            log.warn("derivation_state detect_gaps keyset={} gaps={} gap_count={} current_counter={} total_mints={}", keysetId, gaps, gaps.size(), currentCounter, records.size());
        } else {
            log.debug("derivation_state detect_gaps keyset={} gaps=0", (Object)keysetId);
        }
        return gaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighestRecordedCounter(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        Set<Integer> records = this.mintRecords.get(key);
        if (records == null || records.isEmpty()) {
            log.debug("derivation_state get_highest_counter keyset={} highest=-1 reason=no_mints", (Object)keysetId);
            return -1;
        }
        Set<Integer> set = records;
        synchronized (set) {
            int highest = records.stream().max(Integer::compareTo).orElse(-1);
            log.debug("derivation_state get_highest_counter keyset={} highest={}", (Object)keysetId, (Object)highest);
            return highest;
        }
    }

    @Override
    public boolean hasMintRecord(@NonNull KeysetId keysetId, int counter) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (counter < 0) {
            throw new IllegalArgumentException("Counter must be non-negative, got: " + counter);
        }
        String key = keysetId.toString();
        Set<Integer> records = this.mintRecords.get(key);
        boolean has = records != null && records.contains(counter);
        log.debug("derivation_state has_mint_record keyset={} counter={} has_record={}", keysetId, counter, has);
        return has;
    }

    @Override
    public int getMintCount(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        Set<Integer> records = this.mintRecords.get(key);
        int count = records != null ? records.size() : 0;
        log.debug("derivation_state get_mint_count keyset={} count={}", (Object)keysetId, (Object)count);
        return count;
    }

    @Override
    public void clearKeyset(@NonNull KeysetId keysetId) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        String key = keysetId.toString();
        AtomicInteger oldCounter = this.counters.remove(key);
        Set<Integer> oldRecords = this.mintRecords.remove(key);
        int oldCounterValue = oldCounter != null ? oldCounter.get() : 0;
        int oldMintCount = oldRecords != null ? oldRecords.size() : 0;
        log.warn("derivation_state clear_keyset keyset={} old_counter={} old_mint_count={} action=state_destroyed", keysetId, oldCounterValue, oldMintCount);
    }

    @Override
    public void clearAll() {
        int keysetCount = this.counters.size();
        int totalMints = this.mintRecords.values().stream().mapToInt(Set::size).sum();
        this.counters.clear();
        this.mintRecords.clear();
        log.warn("derivation_state clear_all keysets={} total_mints={} action=all_state_destroyed", (Object)keysetCount, (Object)totalMints);
    }

    public Map<String, KeysetState> exportState() {
        HashMap<String, KeysetState> state = new HashMap<String, KeysetState>();
        for (String keysetId : this.counters.keySet()) {
            int counter = this.counters.get(keysetId).get();
            Set<Integer> records = this.mintRecords.get(keysetId);
            HashSet<Integer> recordsCopy = records != null ? new HashSet<Integer>(records) : new HashSet();
            state.put(keysetId, new KeysetState(counter, recordsCopy));
        }
        log.info("derivation_state export_state keysets={} total_mints={}", (Object)state.size(), (Object)state.values().stream().mapToInt(s -> s.mintRecords.size()).sum());
        return state;
    }

    public void importState(@NonNull Map<String, KeysetState> state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.clearAll();
        for (Map.Entry<String, KeysetState> entry : state.entrySet()) {
            String keysetId = entry.getKey();
            KeysetState keysetState = entry.getValue();
            this.counters.put(keysetId, new AtomicInteger(keysetState.counter));
            Set<Integer> records = Collections.synchronizedSet(new HashSet<Integer>(keysetState.mintRecords));
            this.mintRecords.put(keysetId, records);
        }
        log.info("derivation_state import_state keysets={} total_mints={}", (Object)state.size(), (Object)state.values().stream().mapToInt(s -> s.mintRecords.size()).sum());
    }

    public static class KeysetState {
        public final int counter;
        public final Set<Integer> mintRecords;

        public KeysetState(int counter, Set<Integer> mintRecords) {
            this.counter = counter;
            this.mintRecords = mintRecords;
        }
    }
}

