/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.tasks;

import java.math.BigInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsService;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsServiceImpl;

@Nut(value=4)
public class UnblindSignatureTask<T extends Secret>
implements Task<Proof<T>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnblindSignatureTask.class);
    private final BlindSignature blindSignature;
    private final BigInteger r;
    private final PublicKey K;
    private final T secret;
    private final BDHKEUtilsService utilsService;

    public UnblindSignatureTask(BlindSignature blindSignature, BigInteger r, PublicKey K, T secret) {
        this(blindSignature, r, K, secret, new BDHKEUtilsServiceImpl());
    }

    @Override
    public Proof<T> execute() {
        log.debug("unblind_signature task_started keyset={} amount={} secret_type={}", this.blindSignature.getKeySetId(), this.blindSignature.getAmount(), this.secret.getClass().getSimpleName());
        Signature C_ = this.blindSignature.getBlindedSignature();
        byte[] C = this.utilsService.unblindSignature(C_.getBytes(), Utils.bytesFromBigInteger(this.r), this.K.getBytes());
        Proof proof = Proof.builder().secret(this.secret).amount(this.blindSignature.getAmount()).keySetId(this.blindSignature.getKeySetId().toString()).unblindedSignature(Signature.fromBytes(C)).build();
        log.debug("unblind_signature task_completed keyset={} amount={} secret_type={}", this.blindSignature.getKeySetId(), this.blindSignature.getAmount(), this.secret.getClass().getSimpleName());
        return proof;
    }

    @Generated
    public UnblindSignatureTask(BlindSignature blindSignature, BigInteger r, PublicKey K, T secret, BDHKEUtilsService utilsService) {
        this.blindSignature = blindSignature;
        this.r = r;
        this.K = K;
        this.secret = secret;
        this.utilsService = utilsService;
    }

    @Generated
    public String toString() {
        return "UnblindSignatureTask(blindSignature=" + String.valueOf(this.blindSignature) + ", r=" + String.valueOf(this.r) + ", K=" + String.valueOf(this.K) + ", secret=" + String.valueOf(this.secret) + ", utilsService=" + String.valueOf(this.utilsService) + ")";
    }
}

